/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Baranyi4
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Baranyi IV";
    private static final double F1 = 0.11679;
    private static final double F2 = 0.31255;
    private static final double A1A = 1.22172;
    private static final double A1B = 2.115293;
    private static final double A2A = 38.4308;
    private static final double A2B = 4.58448;
    private static final double B1 = 1.0;
    private static final double B3 = 0.07388;
    private static final double B5 = -0.0538964;
    private static final double B7 = 0.01560242;
    private static final double B9 = -0.001639406;
    private static final double CONST_Y0 = 1.22172 + Math.sqrt(2.115293);
    private static final double MAX_X_OVER_RS = Baranyi4.getFForLambda(Math.PI) * CONST_Y0;
    private static final double MAX_Y_OVER_RS = Baranyi4.getYForLat(90.0);
    private static final double JOIN_Y = 1.40538824071;

    public Baranyi4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y = Baranyi4.getYForLat(lat);
        double yterm = Baranyi4.getYTerm(y);
        double lambdaRad = this.lonToLambdaRad(lon);
        double f = Baranyi4.getFForLambda(lambdaRad);
        double x = f * yterm;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = Baranyi4.iteratePhiRad(absYOverRS);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double yterm = Baranyi4.getYTerm(absYOverRS);
        double f = Math.abs(absXOverRS / yterm);
        double lambdaRad = (Math.exp(0.31255 * f) - 1.0) / 0.11679;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi4 baranyi4 = this;
        synchronized (baranyi4) {
            double y;
            double yOverRS;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Baranyi4.iteratePhiRad(Math.abs(yOverRS = (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double x;
                double xOverRS;
                double f;
                double lambdaRad;
                if (y < 0.0) {
                    phiRad = -phiRad;
                }
                double yterm = Baranyi4.getYTerm(yOverRS);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (Math.exp(0.31255 * (f = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / yterm)) - 1.0) / 0.11679) > Math.PI); ++ix) {
                    double phi = Math.toDegrees(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private static double getYForLat(double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double absPhiRad2 = absPhiRad * absPhiRad;
        double y = absPhiRad * (1.0 + absPhiRad2 * (0.07388 + absPhiRad2 * (-0.0538964 + absPhiRad2 * (0.01560242 + -0.001639406 * absPhiRad2))));
        if (lat < 0.0) {
            y = -y;
        }
        return y;
    }

    private static double getYTerm(double y) {
        double y2 = y * y;
        if (y2 < 1.0E-5) {
            return CONST_Y0;
        }
        if (Math.abs(y) < 1.40538824071) {
            return 1.22172 + Math.sqrt(2.115293 - y2);
        }
        double sqt = 4.58448 + Math.abs(y);
        return Math.sqrt(Math.abs(38.4308 - sqt * sqt));
    }

    private static double getFForLambda(double lambdaRad) {
        double f = Math.log(1.0 + 0.11679 * Math.abs(lambdaRad)) / 0.31255;
        if (lambdaRad < 0.0) {
            return -f;
        }
        return f;
    }

    private static double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * (yOverRS / MAX_Y_OVER_RS);
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = phiRad * (1.0 + phiRad2 * (0.07388 + phiRad2 * (-0.0538964 + phiRad2 * (0.01560242 + -0.001639406 * phiRad2)))) - yOverRS;
            double dfunc = 1.0 + phiRad2 * (0.22164 + phiRad2 * (-0.269482 + phiRad2 * (0.10921694 + -0.014754653999999999 * phiRad2)));
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

