/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import java.lang.invoke.MethodHandles;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjListComponent
extends ProjParamComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 181L;
    private ProjListParameter parameter_;
    private JComboBox<Object> combo_;

    public ProjListComponent(ProjListParameter xparam) {
        this(xparam, xparam.getDefault());
    }

    public ProjListComponent(ProjListParameter xparam, Object value) {
        super(xparam);
        this.parameter_ = xparam;
        this.createLayout(value);
        this.attachListeners();
    }

    @Override
    public JComponent getComponent() {
        return this.combo_;
    }

    private void createLayout(Object value) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ":\u2009");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.combo_ = new JComboBox<Object>(this.parameter_.getChoices());
        this.combo_.setOpaque(false);
        this.combo_.setSelectedItem(value);
        this.combo_.setMaximumRowCount(32);
        this.add(this.combo_);
    }

    private void attachListeners() {
        this.combo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.handleChange();
        });
    }

    public JComboBox<Object> getComboBox() {
        return this.combo_;
    }

    @Override
    public void reset() {
        this.combo_.setSelectedItem(this.parameter_.getDefault());
        this.handleChange();
    }

    @Override
    public String getStringValue() {
        return this.getValue().toString();
    }

    @Override
    public Object getValue() {
        return this.combo_.getSelectedItem();
    }

    public void setValue(Object value) {
        this.parameter_.setValue(value);
        this.combo_.setSelectedItem(this.parameter_.getValue());
        LOGGER.trace("o: {}, {}, {}", value, this.combo_.getSelectedItem(), this.parameter_.getValue());
        this.fireValueChanged();
    }

    @Override
    public void setValue(String value) {
        this.parameter_.setValue(value);
        this.combo_.setSelectedItem(this.parameter_.getValue());
        LOGGER.trace("s: {}, {}, {}", value, this.combo_.getSelectedItem(), this.parameter_.getValue());
        this.fireValueChanged();
    }

    public void setValue(int index) {
        this.combo_.setSelectedIndex(index);
        this.parameter_.setIndex(index);
        LOGGER.trace("i: {}, {}, {}", index, this.combo_.getSelectedItem(), this.parameter_.getValue());
        this.fireValueChanged();
    }

    @Override
    protected void handleChange() {
        this.parameter_.setValue(this.combo_.getSelectedItem());
        this.fireValueChanged();
    }
}

