/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkFolder;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PanAbstractBookmarksMenu
extends PanMenu {
    private static final int ABBREV_LENGTH = 60;

    public PanAbstractBookmarksMenu(PanFrame parent, String mname) {
        super(parent, mname);
    }

    public PanAbstractBookmarksMenu(PanFrame parent) {
        super(parent);
    }

    protected void addBookmarkNodes(PanMenu bmenu, Object ... bobs) {
        for (Object bob : bobs) {
            this.addBookmarkNode(bmenu, bob);
        }
    }

    protected JMenuItem addBookmarkNode(PanMenu bmenu, Object bob) {
        if (bob instanceof PanBookmarkFolder) {
            this.addSubmenu(bmenu, (PanBookmarkFolder)bob);
            return null;
        }
        final PanBookmark b = (PanBookmark)bob;
        String prefix = "";
        switch (b.getAccessType()) {
            case LOCAL_DATASET: {
                prefix = "Local Dataset: ";
                break;
            }
            case REMOTE_DATASET: {
                prefix = "Remote Dataset: ";
                break;
            }
            case CATALOG: {
                prefix = "Catalog: ";
                break;
            }
            default: {
                prefix = "\u2014";
            }
        }
        String name = b.getName();
        String s = null;
        if (b.isNameSet() && name != null && name.length() > 0) {
            s = prefix + name;
        } else {
            String surl = b.getAddress();
            switch (b.getAccessType()) {
                case CATALOG: {
                    surl = surl.replaceAll("catalog\\.xml$", "");
                    surl = surl.replaceAll("catalog\\.html$", "");
                    break;
                }
            }
            if (surl.length() > 60) {
                surl = PanAbstractBookmarksMenu.shortenURL(surl);
            }
            s = prefix + surl;
        }
        AbstractAction a = new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                b.open(PanAbstractBookmarksMenu.this.pframe_);
            }
        };
        JMenuItem jmi = new JMenuItem(a);
        bmenu.add(jmi);
        boolean animating = PanPlotFrame.isAnimationInProgress();
        jmi.setEnabled(!animating);
        return jmi;
    }

    private static String shortenURL(String s) {
        String s2;
        String s1;
        int ii = s.lastIndexOf("://");
        int jj = s.indexOf(47);
        if (ii > 0) {
            s1 = s.substring(0, ii + 3);
            s2 = s.substring(ii + 3);
        } else if (jj == 0) {
            s1 = "/";
            s2 = s.substring(1);
        } else {
            s1 = "";
            s2 = s;
        }
        int kk = s2.indexOf(47);
        int ll = s2.lastIndexOf(47);
        if (kk == -1 || kk == ll) {
            return s;
        }
        String s3 = s2.substring(0, kk + 1);
        Object s4 = s2.substring(kk + 1, ll);
        Object s5 = s2.substring(ll);
        int mlength = Math.max(0, 60 - s1.length() - s3.length() - ((String)s5).length());
        if (mlength <= 0) {
            s4 = "\u2026";
        } else if (((String)s4).length() > mlength) {
            s4 = ((String)s4).substring(0, mlength) + "\u2026";
        }
        int mm = ((String)s5).length();
        if (mm > 60) {
            int remove = mm - 60 + 4;
            s5 = ((String)s5).substring(0, (mm - remove) / 2) + "\u2026" + ((String)s5).substring((mm + remove) / 2);
        }
        return s1 + s3 + (String)s4 + (String)s5;
    }

    protected void addSubmenu(PanMenu bmenu, PanBookmarkFolder folder) {
        PanMenu submenu = new PanMenu(this.pframe_);
        submenu.setText(folder.getName());
        Object[] bobs = folder.getChildren();
        this.addBookmarkNodes(submenu, bobs);
        bmenu.add(submenu);
    }
}

