/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.AmericanPolyconic;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.BonneRegional;
import gov.nasa.giss.map.proj.Cassini;
import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularOblique;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.MercatorRegional;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.RectangularPolyconic;
import gov.nasa.giss.map.proj.TransverseMercator;
import gov.nasa.giss.map.proj.ui.ProjBooleanComponent;
import gov.nasa.giss.map.proj.ui.ProjDoubleComponent;
import gov.nasa.giss.map.proj.ui.ProjIntegerComponent;
import gov.nasa.giss.map.proj.ui.ProjListComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanProjectionComboBox;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.panel.PseudoPalette;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatMapControls
extends PanGridControls
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private PanProjectionComboBox projCombo_;
    private GTextField copLonTF_;
    private GTextField copLatTF_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private QuickBox[] paramRows_;
    private ProjParamComponent[] paramComponents_ = new ProjParamComponent[5];
    private PanButton fixEqRegBtn_;
    private PanButton fixConicBtn_;
    private String lastproj_;
    private boolean refreshing_;
    private boolean zooming_;

    public PanLonLatMapControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        AbstractAction a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemForName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemForName("zoom-plot-out").setAction(a);
    }

    private void createLayout() {
        JLabel projLabel = new JLabel("Projection:\u2009");
        this.projCombo_ = PanProjectionComboBox.small("proj.name", true);
        this.projCombo_.setSelectedItem(this.pmeta_.getString("proj.name"));
        QuickBox projNameBox = QuickBox.createLeftBox(projLabel, this.projCombo_);
        JLabel centerLabel = new JLabel("Center on: ");
        JLabel lonLabel = new JLabel("Lon. ");
        JLabel degELabel = new JLabel("\u00b0E");
        JLabel latLabel = new JLabel(", Lat. ");
        JLabel degNLabel = new JLabel("\u00b0N");
        this.copLonTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("proj.lon0"));
        this.copLatTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("proj.lat0"));
        this.copLonTF_.setName("proj.lon0");
        this.copLatTF_.setName("proj.lat0");
        this.copLonBox_ = QuickBox.createHorizontalBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createHorizontalBox(latLabel, this.copLatTF_, degNLabel);
        QuickBox projCenterBox = QuickBox.createLeftBox(centerLabel, this.copLonBox_, this.copLatBox_);
        JLabel noteLabel = new JLabel("Use 'Grid' controls to manage drawing of parallels and meridians.");
        QuickBox noteBox = QuickBox.createCenterBox(noteLabel);
        this.paramRows_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        this.setLayout(new BoxLayout(this, 1));
        this.add(projNameBox);
        this.add(Box.createVerticalStrut(1));
        this.add(projCenterBox);
        this.add(Box.createVerticalStrut(1));
        this.add(this.paramRows_[0]);
        this.add(Box.createVerticalStrut(1));
        this.add(this.paramRows_[1]);
        this.add(Box.createVerticalStrut(4));
        this.add(this.paramRows_[2]);
        this.add(Box.createVerticalStrut(4));
        this.add(noteBox);
        this.add(Box.createVerticalStrut(4));
        GuiUtils.setSizeSmall(this);
        centerLabel.setPreferredSize(projLabel.getPreferredSize());
        centerLabel.setMaximumSize(centerLabel.getPreferredSize());
        Font xfont = noteLabel.getFont();
        xfont = xfont.deriveFont((float)xfont.getSize() * 0.9f);
        noteLabel.setFont(xfont);
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        if (this.zooming_) {
            return;
        }
        this.refreshing_ = true;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        String projname = proj.getName();
        this.projCombo_.setSelectedItem(this.pmeta_.getString("proj.name"));
        boolean sameProj = projname.equals(this.lastproj_);
        this.lastproj_ = projname;
        LOGGER.trace("sameProj, {}", (Object)sameProj);
        if (sameProj) {
            this.refreshParamFields();
        } else {
            this.changeProjection();
        }
        this.refreshZoomEnabling();
        this.refreshing_ = false;
        this.repaint();
    }

    @Override
    public final void refreshZoomEnabling() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        this.pmeta_.getAction("zoom-plot-in").setEnabled(projmeta.canZoomIn());
        this.pmeta_.getAction("zoom-plot-out").setEnabled(projmeta.canZoomOut());
    }

    private synchronized void refreshParamFields() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        this.refreshing_ = true;
        AbstractProjection proj = projmeta.getProjection();
        int pcount = proj.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            Object value = projmeta.getXParamValue(i);
            if (value == null || value instanceof String && ((String)value).isEmpty()) continue;
            ProjParamComponent xcomp = this.paramComponents_[i];
            try {
                if (value instanceof String) {
                    xcomp.setValue((String)value);
                    continue;
                }
                if (xcomp instanceof ProjDoubleComponent && value instanceof Double) {
                    ((ProjDoubleComponent)xcomp).setValue((Double)value);
                    continue;
                }
                if (xcomp instanceof ProjIntegerComponent && value instanceof Integer) {
                    ProjIntegerComponent pic = (ProjIntegerComponent)xcomp;
                    pic.setValue((Integer)value);
                    continue;
                }
                if (xcomp instanceof ProjBooleanComponent && value instanceof Boolean) {
                    ((ProjBooleanComponent)xcomp).setSelected((Boolean)value);
                    continue;
                }
                if (xcomp instanceof ProjListComponent) {
                    ((ProjListComponent)xcomp).setValue(value.toString());
                    continue;
                }
                LOGGER.debug("xcomp {} {} does not match known type.", (Object)i, (Object)xcomp.getClass());
                continue;
            }
            catch (Exception exc) {
                LOGGER.debug("xcomp {} exc: {}", (Object)i, (Object)exc.toString());
            }
        }
        this.refreshing_ = false;
    }

    private void changeProjection() {
        int i;
        double projLon;
        double tfLon;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        LOGGER.trace("proj {}", (Object)proj.getName());
        this.copLonTF_.setEnabled(proj.isRecenterableLon());
        this.copLatTF_.setEnabled(proj.isRecenterableLat());
        if (proj.isRecenterableLon() && (tfLon = this.getCopLon()) != (projLon = proj.getCenter().getLon())) {
            this.handleCenterTF(true);
        }
        for (i = 0; i < this.paramRows_.length; ++i) {
            this.paramRows_[i].removeAll();
        }
        for (i = 0; i < this.paramComponents_.length; ++i) {
            this.paramComponents_[i] = null;
        }
        int pcount = proj.getExtraParamCount();
        int pRow = 0;
        int pRowItem = 0;
        for (int i2 = 0; i2 < pcount; ++i2) {
            ProjParamComponent xcomp;
            if (pRowItem > 0) {
                this.paramRows_[pRow].add(new JLabel(", "));
            }
            int pid = i2;
            this.paramComponents_[i2] = xcomp = proj.getParamComponent(i2);
            GuiUtils.setSizeSmall(xcomp);
            xcomp.setMaximumSize(xcomp.getPreferredSize());
            this.paramRows_[pRow].add(xcomp);
            if (xcomp instanceof ProjListComponent) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 2) {
                ++pRow;
                pRowItem = 0;
            }
            xcomp.addChangeListener(e -> this.handleExtraParam(xcomp, pid));
        }
        this.refreshParamFields();
        if (proj instanceof EquirectangularRegional) {
            if (this.fixEqRegBtn_ == null) {
                this.fixEqRegBtn_ = PanButton.small("Fix Proportions");
                this.fixEqRegBtn_.addActionListener(e -> this.fixEqRegional());
            }
            this.paramRows_[2].add(Box.createHorizontalGlue());
            this.paramRows_[2].add(this.fixEqRegBtn_);
            this.paramRows_[2].add(Box.createHorizontalGlue());
        } else if (proj.hasProperty(16)) {
            if (this.fixConicBtn_ == null) {
                this.fixConicBtn_ = PanButton.small("Autoset Parallels");
                this.fixConicBtn_.addActionListener(e -> this.fixConic());
            }
            this.paramRows_[2].add(Box.createHorizontalGlue());
            this.paramRows_[2].add(this.fixConicBtn_);
            this.paramRows_[2].add(Box.createHorizontalGlue());
        }
        this.paramRows_[0].add(Box.createHorizontalGlue());
        this.paramRows_[1].add(Box.createHorizontalGlue());
        GuiUtils.setSizeSmall(this.copLatBox_);
        GuiUtils.setSizeSmall(this.paramRows_[0]);
        GuiUtils.setSizeSmall(this.paramRows_[1]);
        GuiUtils.setSizeSmall(this.paramRows_[2]);
        this.copLonBox_.invalidate();
        this.copLatBox_.invalidate();
        this.paramRows_[0].invalidate();
        this.paramRows_[1].invalidate();
        this.paramRows_[2].invalidate();
        this.setPreferredSize(null);
        this.invalidate();
        Container cc = this;
        while (true) {
            if (cc instanceof Window || cc instanceof PseudoPalette) {
                ((Component)cc).revalidate();
                cc.repaint();
                break;
            }
            cc.setSize(((Component)cc).getPreferredSize());
            Container parent = cc.getParent();
            if (parent == null) {
                ((Component)cc).revalidate();
                break;
            }
            parent.setPreferredSize(null);
            parent.setSize(parent.getPreferredSize());
            parent.invalidate();
            cc = parent;
        }
    }

    private void attachListeners() {
        this.projCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.projCombo_.isRefreshing()) {
                return;
            }
            String name = this.projCombo_.getSelectedItem().toString();
            this.pmeta_.setString("proj.name", name);
            this.scheduleRefreshTask();
        });
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLonLatMapControls.this.handleCenterTF(false);
            }
        };
        this.copLonTF_.addFocusListener(lonlatFL);
        this.copLatTF_.addFocusListener(lonlatFL);
        this.copLonTF_.addActionListener(e -> this.handleCenterTF(false));
        this.copLatTF_.addActionListener(e -> this.handleCenterTF(false));
    }

    private boolean isZoomable() {
        return this.pmeta_.getProjectionMeta().isZoomable();
    }

    @Override
    public void recenter(double lon, double lat) {
        double newlon;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Invalid latitude.");
        }
        double newlat = lat;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj instanceof EquirectangularRegional) {
            double hhh = 0.0;
            try {
                Object oo = projmeta.getXParamValue(1);
                if (oo instanceof Double) {
                    hhh = (Double)oo;
                } else if (oo instanceof String) {
                    hhh = StringUtils.parseDouble((String)oo);
                }
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return;
            }
            double halfH = 0.5 * hhh;
            if (newlat + halfH > 90.0) {
                newlat = 90.0 - halfH;
            } else if (newlat - halfH < -90.0) {
                newlat = -90.0 + halfH;
            }
        }
        for (newlon = lon; newlon > 180.0; newlon -= 360.0) {
        }
        while (newlon < -180.0) {
            newlon += 360.0;
        }
        double oldlon = this.getCopLon();
        double oldlat = this.getCopLat();
        if (this.copLonTF_.isEnabled()) {
            if (Double.isNaN(oldlon)) {
                oldlon = -9999.0;
            }
            if (newlon != oldlon) {
                this.copLonTF_.setText(PFORMAT_7G.sprintfx(newlon));
            }
        } else {
            newlon = oldlon;
        }
        if (this.copLatTF_.isEnabled()) {
            if (Double.isNaN(oldlat)) {
                oldlat = -9999.0;
            }
            if (newlat != oldlat) {
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(newlat));
            }
        } else {
            newlat = oldlat;
        }
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"proj.lon0", newlon}, {"proj.lat0", newlat});
        }
    }

    private void handleCenterTF(boolean force) {
        PanProjectionMeta projmeta;
        AbstractProjection proj;
        double lat;
        if (this.refreshing_ && !force) {
            return;
        }
        if (this.copLonTF_ == null || this.copLatTF_ == null) {
            return;
        }
        if (this.pmeta_ == null) {
            return;
        }
        double lon = this.getCopLon();
        if (Double.isNaN(lon)) {
            lon = this.pmeta_.getDouble("proj.lon0");
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        boolean shifted = false;
        while (lon > 180.0) {
            lon -= 360.0;
            shifted = true;
        }
        while (lon < -180.0) {
            lon += 360.0;
            shifted = true;
        }
        if (shifted) {
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(lon));
        }
        if (Math.abs(lat = this.getCopLat()) > 90.0) {
            lat = 90.0 * Math.signum(lat);
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
        }
        if ((proj = (projmeta = this.pmeta_.getProjectionMeta()).getProjection()) instanceof EquirectangularRegional) {
            double hhh = 0.0;
            try {
                Object oo = projmeta.getXParamValue(1);
                if (oo instanceof Double) {
                    hhh = (Double)oo;
                } else if (oo instanceof String) {
                    hhh = StringUtils.parseDouble((String)oo);
                }
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return;
            }
            double halfH = 0.5 * hhh;
            if (lat + halfH > 90.0) {
                lat = 90.0 - halfH;
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            } else if (lat - halfH < -90.0) {
                lat = -90.0 + halfH;
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            }
        }
        this.pmeta_.setGroup({"proj.lon0", lon}, {"proj.lat0", lat});
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double lon, double lat) {
        this.zoom(1.5, lon, lat);
    }

    @Override
    public void zoomOut(double lon, double lat) {
        this.zoom(0.6666666666666666, lon, lat);
    }

    @Override
    public void zoom(double factor) {
        String pname;
        if (!this.isZoomable()) {
            return;
        }
        double lon = 0.0;
        double lat = 0.0;
        if (this.copLonTF_.isEnabled() && Double.isNaN(lon = this.getCopLon())) {
            LOGGER.warn("Using default longitude 0.");
            lon = 0.0;
        }
        if ((pname = this.pmeta_.getString("proj.name")).equals("Equirectangular")) {
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(0.0));
            lat = 0.0;
        } else if (this.copLatTF_.isEnabled() && Double.isNaN(lat = this.getCopLat())) {
            LOGGER.warn("Using default latitude 0.");
            lat = 0.0;
        }
        this.zoom(factor, lon, lat);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void zoom(double factor, double lon, double lat) {
        if (!this.isZoomable()) {
            return;
        }
        this.zooming_ = true;
        oldLon = this.getCopLon();
        if (Double.isNaN(oldLon)) {
            oldLon = -9999.0;
        }
        if (lon != oldLon) {
            this.copLonTF_.setText(PanLonLatMapControls.PFORMAT_7G.sprintfx(lon));
        }
        if (Double.isNaN(oldLat = this.getCopLat())) {
            oldLat = -9999.0;
        }
        if (lat != oldLat) {
            this.copLatTF_.setText(PanLonLatMapControls.PFORMAT_7G.sprintfx(lat));
        }
        if ((proj = (projmeta = this.pmeta_.getProjectionMeta()).getProjection()) instanceof Equirectangular || proj instanceof EquirectangularRegional) {
            w = 360.0;
            h = 180.0;
            if (proj instanceof EquirectangularRegional) {
                try {
                    woo = projmeta.getXParamValue(0);
                    hoo = projmeta.getXParamValue(1);
                    if (woo == null) {
                        PanLonLatMapControls.LOGGER.debug("Width object is null");
                    } else if (woo instanceof Double) {
                        w = (Double)woo;
                    } else if (woo instanceof String) {
                        w = StringUtils.parseDouble((String)woo);
                    } else {
                        PanLonLatMapControls.LOGGER.debug("No match for width object class {}", (Object)woo.getClass());
                    }
                    if (hoo == null) {
                        PanLonLatMapControls.LOGGER.debug("Height object is null");
                    } else if (hoo instanceof Double) {
                        h = (Double)hoo;
                    } else if (hoo instanceof String) {
                        h = StringUtils.parseDouble((String)hoo);
                    } else {
                        PanLonLatMapControls.LOGGER.debug("No match for height object class {}", (Object)hoo.getClass());
                    }
                }
                catch (Exception exc) {
                    PanLonLatMapControls.LOGGER.debug("Exception handling equirect-reg, {}", (Object)exc.getMessage());
                    if (PanLonLatMapControls.LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    this.zooming_ = false;
                    return;
                }
            }
            w = Math.min(w / factor, 360.0);
            h = Math.min(h / factor, 180.0);
            if (w == 360.0 && h == 180.0) {
                this.projCombo_.setSelectedItem("Equirectangular");
                this.pmeta_.setGroup(new Object[][]{{"proj.name", "Equirectangular"}, {"proj.lon0", lon}, {"proj.lat0", lat}});
            } else {
                newlat = lat;
                halfH = 0.5 * h;
                if (lat + halfH > 90.0) {
                    newlat = 90.0 - halfH;
                    this.copLatTF_.setText(PanLonLatMapControls.PFORMAT_7G.sprintfx(newlat));
                } else if (lat - halfH < -90.0) {
                    newlat = -90.0 + halfH;
                    this.copLatTF_.setText(PanLonLatMapControls.PFORMAT_7G.sprintfx(newlat));
                }
                this.projCombo_.setSelectedItem("Equirectangular Regional");
                this.pmeta_.setGroup(new Object[][]{{"proj.name", "Equirectangular Regional"}, {"proj.lon0", lon}, {"proj.lat0", newlat}, {"proj.xparam.1", w}, {"proj.xparam.2", h}});
            }
        } else {
            if (proj instanceof EquirectangularOblique || proj instanceof TransverseMercator || proj instanceof AmericanPolyconic || proj instanceof Cassini || proj instanceof MercatorRegional) {
                try {
                    sizeParam = (ProjDoubleParameter)proj.getParameter(0);
                    size = sizeParam.getValue();
                    size /= factor;
                    size = Math.min(size, sizeParam.getMaximum());
                    size = Math.max(size, sizeParam.getMinimum());
                    if (this.pmeta_ != null) {
                        this.pmeta_.setGroup(new Object[][]{{"proj.lon0", lon}, {"proj.lat0", lat}, {"proj.xparam.1", size}});
                    }
                    ((ProjDoubleComponent)this.paramComponents_[0]).setValue(size);
                }
                catch (Exception exc) {
                    PanLonLatMapControls.LOGGER.debug("Exception handling various, {}", (Object)exc.getMessage());
                    if (PanLonLatMapControls.LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    this.zooming_ = false;
                    return;
                }
            }
            if (proj instanceof BonneRegional || proj instanceof RectangularPolyconic) {
                try {
                    sizeParam = (ProjDoubleParameter)proj.getParameter(1);
                    size = sizeParam.getValue();
                    size /= factor;
                    size = Math.min(size, sizeParam.getMaximum());
                    size = Math.max(size, sizeParam.getMinimum());
                    if (this.pmeta_ != null) {
                        this.pmeta_.setGroup(new Object[][]{{"proj.lon0", lon}, {"proj.lat0", lat}, {"proj.xparam.1", lat}, {"proj.xparam.2", size}});
                    }
                    ((ProjDoubleComponent)this.paramComponents_[0]).setValue(lat);
                    ((ProjDoubleComponent)this.paramComponents_[1]).setValue(size);
                }
                catch (Exception exc) {
                    PanLonLatMapControls.LOGGER.debug("Exception handling Bonne/RectPoly, {}", (Object)exc.getMessage());
                    if (PanLonLatMapControls.LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    this.zooming_ = false;
                    return;
                }
            }
            if (proj instanceof AzimuthalProjection) {
                try {
                    cap = ((AzimuthalProjection)proj).getEdgeAngleParameter();
                    if (cap == null) ** GOTO lbl146
                    paramKey = "proj.xparam.1";
                    if (this.paramComponents_[1] != null && cap == this.paramComponents_[1].getParameter()) {
                        paramKey = "proj.xparam.2";
                    }
                    if (this.paramComponents_[2] != null && cap == this.paramComponents_[2].getParameter()) {
                        paramKey = "proj.xparam.3";
                    }
                    r = cap.getValue();
                    r /= factor;
                    r = Math.min(r, cap.getMaximum());
                    r = Math.max(r, cap.getMinimum());
                    if (this.pmeta_ != null) {
                        this.pmeta_.setGroup(new Object[][]{{"proj.lon0", lon}, {"proj.lat0", lat}, {paramKey, r}});
                    }
                    ((ProjDoubleComponent)this.paramComponents_[0]).setValue(r);
                }
                catch (Exception exc) {
                    PanLonLatMapControls.LOGGER.debug("Exception handling azimuthal, {}", (Object)exc.getMessage());
                    if (PanLonLatMapControls.LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    this.zooming_ = false;
                    return;
                }
            } else if (proj.hasProperty(16)) {
                try {
                    hp = ((ConicProjection)proj).getHeightParameter();
                    hh = hp.getValue();
                    hh /= factor;
                    hh = Math.min(hh, hp.getMaximum());
                    hh = Math.max(hh, hp.getMinimum());
                    if (this.pmeta_ != null) {
                        this.pmeta_.setGroup(new Object[][]{{"proj.lon0", lon}, {"proj.lat0", lat}, {"proj.xparam.3", hh}});
                    }
                    ((ProjDoubleComponent)this.paramComponents_[2]).setValue(hh);
                }
                catch (Exception exc) {
                    PanLonLatMapControls.LOGGER.debug("Exception handling conic, {}", (Object)exc.getMessage());
                    if (PanLonLatMapControls.LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    this.zooming_ = false;
                    return;
                }
            }
        }
lbl146:
        // 9 sources

        this.refresh();
        this.zooming_ = false;
    }

    @Override
    public void dragZoom(double clon, double clat, double llon, double tlat, double rlon, double blat) {
        double oldLat;
        if (!this.isZoomable()) {
            return;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        double oldLon = this.getCopLon();
        if (Double.isNaN(oldLon)) {
            oldLon = -9999.0;
        }
        if (clon != oldLon) {
            this.copLonTF_.setText(PFORMAT_7G.sprintfx(clon));
        }
        if (Double.isNaN(oldLat = this.getCopLat())) {
            oldLat = -9999.0;
        }
        if (clat != oldLat) {
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(clat));
        }
        if (proj instanceof Equirectangular || proj instanceof EquirectangularRegional) {
            double w = Math.min(rlon - llon, 360.0);
            double h = Math.min(tlat - blat, 180.0);
            if (proj instanceof Equirectangular) {
                this.pmeta_.setGroup({"proj.name", "Equirectangular Regional"}, {"proj.lon0", clon}, {"proj.lat0", clat}, {"proj.xparam.1", w}, {"proj.xparam.2", h});
                this.projCombo_.setSelectedItem("Equirectangular Regional");
                this.copLatTF_.setEnabled(true);
                ((ProjDoubleComponent)this.paramComponents_[0]).setValue(w);
                ((ProjDoubleComponent)this.paramComponents_[1]).setValue(h);
            } else {
                this.pmeta_.setGroup({"proj.lon0", clon}, {"proj.lat0", clat}, {"proj.xparam.1", w}, {"proj.xparam.2", h});
            }
        } else if (proj instanceof AzimuthalProjection) {
            ProjDoubleParameter cap = ((AzimuthalProjection)proj).getEdgeAngleParameter();
            double r = Math.max(Math.abs(tlat - clat), Math.abs(blat - clat));
            r = Math.min(r, cap.getMaximum());
            r = Math.max(r, cap.getMinimum());
            ((ProjDoubleComponent)this.paramComponents_[0]).setValue(r);
            this.pmeta_.setGroup({"proj.lon0", clon}, {"proj.lat0", clat}, {"proj.xparam.1", r});
        } else if (proj instanceof ConicProjection || proj instanceof BonneRegional) {
            LOGGER.warn("Drag zoom not yet coded for conic projections.");
        } else {
            LOGGER.warn("Tried to set edges on non-zoomable projection.");
        }
    }

    @Override
    public void resetGridBounds() {
    }

    private void setRegionalFields(double w, double h) {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj instanceof EquirectangularRegional) {
            ((ProjDoubleComponent)this.paramComponents_[0]).setValue(w);
            ((ProjDoubleComponent)this.paramComponents_[1]).setValue(h);
            if (this.pmeta_ != null) {
                this.pmeta_.setGroup({"proj.xparam.1", w}, {"proj.xparam.2", h});
            }
        } else {
            LOGGER.warn("Tried to set regional width and height on non-ER projection.");
        }
    }

    private void handleExtraParam(ProjParamComponent pf, int pid) {
        if (pf == null || !pf.isVisible()) {
            return;
        }
        if (this.refreshing_ || this.zooming_) {
            return;
        }
        Object pvalue = pf.getValue();
        try {
            String pkey = "proj.xparam." + (pid + 1);
            this.pmeta_.set(pkey, pvalue);
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            AbstractProjection proj = projmeta.getProjection();
            if (proj.hasProperty(0x1000000)) {
                this.copLonTF_.setEnabled(proj.isRecenterableLon());
                this.copLonTF_.setText(PFORMAT_7G.sprintfx(proj.getCenter().getLon()));
                PanPlotFrame pframe = this.pmeta_.getFrame();
                try {
                    pframe.getControlsPanel(PanPlotControlsID.GRID).refresh();
                }
                catch (Exception exc) {
                    LOGGER.trace("Could not find grid controls to request a refresh");
                }
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse parameter field value: []", (Object)pf.toString());
        }
    }

    private void fixEqRegional() {
        double lat;
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        if (lat > 85.0) {
            lat = 85.0;
        } else if (lat < -85.0) {
            lat = -85.0;
        }
        double coslat = Math.cos(Math.toRadians(lat));
        ProjDoubleComponent hfield = (ProjDoubleComponent)this.paramComponents_[1];
        double h1 = (Double)hfield.getValue();
        int wfactor = this.pmeta_.getInt("size.width");
        int hfactor = this.pmeta_.getInt("size.height");
        double whratio = (double)wfactor / (double)hfactor;
        double w2 = h1 * whratio / coslat;
        double h2 = h1;
        if (w2 > 360.0) {
            w2 = 360.0;
            h2 = w2 * coslat / whratio;
        }
        if (h2 > 180.0) {
            h2 = 180.0;
        }
        this.setRegionalFields(w2, h2);
    }

    private void fixConic() {
        double lat;
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        ProjDoubleComponent p1field = (ProjDoubleComponent)this.paramComponents_[0];
        ProjDoubleComponent p2field = (ProjDoubleComponent)this.paramComponents_[1];
        ProjDoubleComponent hfield = (ProjDoubleComponent)this.paramComponents_[2];
        double h = (Double)hfield.getValue();
        if (h < 0.0) {
            h = 1.0;
        }
        double p1 = lat + 0.3 * h;
        double p2 = lat - 0.3 * h;
        if (p1 > 90.0) {
            p1 = 90.0;
        }
        if (p2 < -90.0) {
            p2 = -90.0;
        }
        p1field.setValue(p1);
        p2field.setValue(p2);
        if (this.pmeta_ != null) {
            this.pmeta_.setGroup({"proj.xparam.1", p1}, {"proj.xparam.2", p2});
        }
    }

    private double getCopLon() {
        String s = this.copLonTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lon TF '{}'", (Object)s);
            return Double.NaN;
        }
    }

    private double getCopLat() {
        String s = this.copLatTF_.getText();
        try {
            return StringUtils.parseDouble(s);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not parse lat TF '{}')", (Object)s);
            return Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatMapControls panLonLatMapControls = this;
        synchronized (panLonLatMapControls) {
            this.paramRows_[0].removeAll();
            this.paramRows_[1].removeAll();
            this.paramRows_[2].removeAll();
            super.flush();
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("proj.name")) {
            this.refreshPrivate();
        }
        this.repaint();
    }
}

