/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.exc.NcResourceNotFoundException;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public class PanOpenCatalogTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object address_;
    private URL url_;
    private URL urlA_;
    private URL urlB_;
    private String errMsg_;
    private boolean tryAgainOnEDT_;
    private NcCatalog catalog_;

    public PanOpenCatalogTask(Object address) {
        super("Opening remote catalog");
        Objects.requireNonNull(address, "Address cannot be null.");
        LOGGER.trace("Address is {}", (Object)address.getClass().getSimpleName());
        this.address_ = address;
    }

    @Override
    protected Object beginTask() {
        block29: {
            block28: {
                this.url_ = null;
                if (this.address_ instanceof URL) {
                    this.url_ = (URL)this.address_;
                } else {
                    try {
                        if (this.address_ instanceof URI) {
                            this.url_ = ((URI)this.address_).toURL();
                            break block28;
                        }
                        if (this.address_ instanceof String) {
                            this.url_ = new URL((String)this.address_);
                            break block28;
                        }
                        if (this.address_ instanceof DatasetUrl) {
                            this.errMsg_ = "Not yet able to work with a DatasetUrl.";
                            return null;
                        }
                        this.errMsg_ = "Catalog address is of unknown class: " + this.address_.getClass().getSimpleName() + ".";
                        return null;
                    }
                    catch (MalformedURLException exc) {
                        this.errMsg_ = "Catalog address looks malformed.";
                        return null;
                    }
                    catch (Exception exc) {
                        this.errMsg_ = "Unable to construct URL from: " + this.address_;
                        return null;
                    }
                }
            }
            if (this.url_ == null) {
                this.errMsg_ = "Specified URL is null?";
                return null;
            }
            try {
                Object urlString = this.url_.toString();
                if (((String)urlString).endsWith("catalog.xml")) {
                    this.urlA_ = this.url_;
                }
                if (((String)urlString).matches(".*(catalog|index).html$")) {
                    urlString = ((String)urlString).replaceAll("(catalog|index).html$", "catalog.xml");
                    this.urlA_ = new URL((String)urlString);
                } else if (((String)urlString).endsWith("/")) {
                    urlString = (String)urlString + "catalog.xml";
                    this.urlA_ = new URL((String)urlString);
                } else {
                    this.urlA_ = this.url_;
                }
                String urlAString = this.urlA_.toString();
                if (!urlAString.endsWith("/catalog.xml")) {
                    this.urlB_ = new URL((String)urlString + "/catalog.xml");
                }
            }
            catch (MalformedURLException exc) {
                this.errMsg_ = "Unable to create a catalog.xml URL from the address provided.";
                return null;
            }
            catch (Exception exc) {
                this.errMsg_ = "Unable to create a catalog.xml URL due to " + exc.getClass().getSimpleName();
                return null;
            }
            try {
                this.openCatalog();
            }
            catch (Exception exc) {
                LOGGER.debug("Exception: " + exc.getClass().getSimpleName());
                this.errMsg_ = exc.toString().replaceFirst(".*HTTP", "HTTP");
                if (this.errMsg_.contains("Connection refused")) {
                    this.errMsg_ = "Connection was refused.";
                }
                if (this.errMsg_.contains("401")) {
                    this.errMsg_ = "User authentication is required.";
                }
                if (this.errMsg_.contains("FileNotFound") || this.errMsg_.contains("404")) {
                    this.errMsg_ = "No catalog was found at that address.";
                }
                if (this.errMsg_.contains("502")) {
                    this.errMsg_ = "Unable to fulfill request, possibly due to an upstream server error.";
                }
                if (this.errMsg_.contains("503")) {
                    this.errMsg_ = "Server seems to be refusing connection.";
                }
                if (this.errMsg_.contains("Remote host terminated the handshake")) {
                    this.errMsg_ = "Remote host terminated the handshake.";
                }
                if (this.errMsg_.contains("ParseException") || this.errMsg_.contains("parser")) {
                    this.errMsg_ = "Unable to parse catalog XML.";
                }
                if (this.errMsg_.contains("NcException")) {
                    this.errMsg_ = exc.getMessage();
                }
                LOGGER.warn("Unknown addCatalog response -\n{}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block29;
                exc.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.catalog_ == null && this.catalog_ == null && this.tryAgainOnEDT_) {
            LOGGER.trace("Making second attempt on EDT");
            this.openCatalog();
            LOGGER.trace("Opened? {}", (Object)(this.catalog_ != null ? 1 : 0));
        }
        if (this.errMsg_ != null) {
            SlowMessage.show(null, "File Error", new StringBuilder("There was an error opening the remote address: ").append(this.errMsg_));
            return;
        }
        if (this.catalog_ == null) {
            LOGGER.trace("No error msg but catalog is null");
            SlowMessage.show(null, "File Error", "Somehow got a null but not an error when trying to open the catalog. Sorry; we know that isn't very helpful.");
            return;
        }
        PanSourcesFrame sourcesFrame = PanSourcesFrame.getSharedInstance();
        try {
            sourcesFrame.addCatalog(this.catalog_);
        }
        catch (Exception exc) {
            if (exc.toString().contains("already")) {
                SlowMessage.show(null, "File Error", new StringBuilder("TThere is already a catalog open at that address."));
            } else {
                LOGGER.debug("Exception adding catalog to UI: {}", (Object)exc.getClass().getSimpleName());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
            return;
        }
        sourcesFrame.reveal();
        sourcesFrame.refresh();
    }

    private void openCatalog() {
        block11: {
            boolean onEDT = EventQueue.isDispatchThread();
            boolean headless = PlatformUtils.isHeadless();
            LOGGER.trace("EDT {}, headless {}", (Object)onEDT, (Object)headless);
            LOGGER.trace("Trying URL A: {}", (Object)this.urlA_);
            try {
                this.catalog_ = this.openCatalog(this.urlA_);
            }
            catch (HeadlessException exc) {
                LOGGER.warn("HeadlessException opening catalog.");
                if (headless) {
                    LOGGER.trace("How the heck are we running headless?");
                    this.tryAgainOnEDT_ = false;
                    this.errMsg_ = "Headles exception.";
                } else if (onEDT) {
                    LOGGER.trace("How the heck did we get a HeadlessException while on the EDT?");
                    this.tryAgainOnEDT_ = false;
                    this.errMsg_ = "Headless exception on EDT?";
                } else {
                    LOGGER.warn("Will try again on EDT.");
                    this.tryAgainOnEDT_ = true;
                    this.errMsg_ = null;
                }
                return;
            }
            catch (Exception exc) {
                LOGGER.trace("Exception trying URL A: {}", (Object)exc.toString());
                if (this.urlB_ != null) break block11;
                LOGGER.trace("And there is no URL B");
                throw exc;
            }
        }
        if (this.catalog_ != null) {
            return;
        }
        LOGGER.trace("Trying URL B: {}", (Object)this.urlB_);
        try {
            this.catalog_ = this.openCatalog(this.urlB_);
        }
        catch (Exception exc) {
            LOGGER.trace("Exception trying URL B.");
            throw exc;
        }
        if (this.catalog_ == null) {
            LOGGER.trace("No catalog found at {} or {}", (Object)this.urlA_, (Object)this.urlB_);
            throw new RuntimeException("No catalog found at that address.");
        }
    }

    private NcCatalog openCatalog(URL url) {
        try {
            URI uri = url.toURI();
            return new NcCatalog(null, uri);
        }
        catch (FileNotFoundException fnfe) {
            throw new NcResourceNotFoundException("No catalog found at that address.");
        }
        catch (NcException nce) {
            throw nce;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to access catalog at that address.", ioe);
        }
        catch (Exception exc) {
            throw new RuntimeException("Unable to access catalog at that address.", exc);
        }
    }

    public NcCatalog getCatalog() {
        return this.catalog_;
    }
}

