/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotControlsID implements DescribedItem
{
    ARRAYS("show-array-controls", "Arrays"),
    CONTOURS("show-contour-controls", "Contours"),
    GRID("show-grid-controls", "Grid"),
    LABELS("show-label-controls", "Labels"),
    LAYOUT("show-layout-controls", "Layout"),
    MAP("show-map-controls", "Map Projection"),
    OVERLAYS("show-overlay-controls", "Overlays"),
    SCALE("show-scale-controls", "Scale"),
    SHADING("show-shading-controls", "Shading"),
    STROKE("show-stroke-controls", "Stroke"),
    TRAJECTORY("show-trajectory-controls", "Trajectory"),
    VECTORS("show-vector-controls", "Vectors"),
    ALPHA("show-alpha-controls", "DEVO: Alpha"),
    NUMBERLAY("show-numberlay-controls", "DEVO: Numberlay"),
    UNIFIED("show-unified-controls", "Plot Controls");

    final String uiKey_;
    final String description_;

    private PanPlotControlsID(String key, String description) {
        this.uiKey_ = key;
        this.description_ = description;
    }

    public String getActionKey() {
        return this.uiKey_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanPlotControlsID matching(String str) {
        for (PanPlotControlsID item : PanPlotControlsID.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

