/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.Windoid;
import gov.nasa.giss.ui.windoid.WindoidHeader;
import gov.nasa.giss.ui.windoid.WindoidHeaderMouseListener;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWindoidHeaderMouseAdapter
implements WindoidHeaderMouseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected WindoidHeader header_;
    private boolean dragInProgress_;
    private Point windowPoint_;
    private Point mousePoint_;
    private long lastClick_;

    public SimpleWindoidHeaderMouseAdapter(WindoidHeader header) {
        LOGGER.trace("");
        this.header_ = header;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        LOGGER.trace("{}");
        Point pt = e.getPoint();
        if (this.header_.inCloseButton(pt)) {
            LOGGER.trace("close button");
            if (this.header_.isCloseable()) {
                ((Windoid)this.header_.getTopLevelAncestor()).setVisible(false);
            }
        } else if (this.header_.inResizeButton(pt)) {
            LOGGER.trace("resize button");
        } else if (this.header_.inHideButton(pt)) {
            LOGGER.trace("hide button");
        } else if (e.getClickCount() == 2) {
            LOGGER.trace("double click");
            ((Windoid)this.header_.getTopLevelAncestor()).toggleCollapsed();
        } else if (e.getClickCount() == 1) {
            long ctime = System.currentTimeMillis();
            long diff = ctime - this.lastClick_;
            LOGGER.trace("click diff {}", (Object)diff);
            if (diff < 15L) {
                LOGGER.trace("possible double click");
                this.lastClick_ = 0L;
            } else {
                this.lastClick_ = ctime;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveWindoid(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(false);
            this.header_.setResizeHighlighted(false);
            this.header_.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragInProgress_ = true;
        Container parent = this.header_.getTopLevelAncestor();
        if (parent != null) {
            this.windowPoint_ = parent.getLocation();
            this.mousePoint_ = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveWindoid(e.getPoint());
        this.dragInProgress_ = false;
    }

    private void moveWindoid(Point p) {
        if (!this.dragInProgress_) {
            return;
        }
        int dx = p.x - this.mousePoint_.x;
        int dy = p.y - this.mousePoint_.y;
        this.windowPoint_.translate(dx, dy);
        Container parent = this.header_.getTopLevelAncestor();
        parent.setLocation(this.windowPoint_);
    }
}

