/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.menu.GissMenuBar;
import gov.nasa.giss.ui.windoid.Windoid;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindoidKeyEventDispatcher
implements KeyEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JFrame pframe_;
    private final Windoid windoid_;

    public WindoidKeyEventDispatcher(JFrame pframe, Windoid windoid) {
        this.pframe_ = pframe;
        this.windoid_ = windoid;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        JMenuBar jmb;
        if (!this.windoid_.isVisible()) {
            return false;
        }
        if (!this.pframe_.isVisible()) {
            return false;
        }
        int iid = e.getID();
        if (iid != 401) {
            return false;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component kfo = kfm.getPermanentFocusOwner();
        if (kfo == null) {
            kfo = kfm.getFocusOwner();
        }
        if (kfo == null) {
            LOGGER.trace("No keyboard focus owner");
            return false;
        }
        if (kfo instanceof Windoid) {
            if (kfo != this.windoid_) {
                return false;
            }
        } else if (kfo instanceof JComponent) {
            Container tla = ((JComponent)kfo).getTopLevelAncestor();
            if (tla != this.windoid_) {
                LOGGER.trace("JComponent TL ancestor is not a Windoid.");
                return false;
            }
        } else {
            LOGGER.trace("Unknown KFO class, {}", (Object)kfo.getClass().getSimpleName());
            return false;
        }
        if (!((jmb = this.pframe_.getJMenuBar()) instanceof GissMenuBar)) {
            LOGGER.trace("Menubar is not a GissMenuBar");
            return false;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        JMenuItem jmi = ((GissMenuBar)jmb).getItemForKeyStroke(ks);
        LOGGER.trace("ks {}", (Object)ks);
        if (jmi == null) {
            LOGGER.trace("jmi is null");
            return this.passViaActionMap(ks);
        }
        Action a = jmi.getAction();
        if (a == null) {
            LOGGER.trace("action is null");
            return false;
        }
        LOGGER.trace("enabled? jmi {}, a {}", (Object)jmi.isEnabled(), (Object)a.isEnabled());
        if (!jmi.isEnabled() || !a.isEnabled()) {
            return false;
        }
        EventQueue.invokeLater(() -> {
            ActionEvent ee = new ActionEvent(jmi, 1001, jmi.getText(), System.currentTimeMillis(), e.getModifiers());
            a.actionPerformed(ee);
        });
        return true;
    }

    private boolean passViaActionMap(KeyStroke ks) {
        LOGGER.trace("ks {}", (Object)ks);
        InputMap im = this.pframe_.getRootPane().getInputMap(2);
        Object oo = im.get(ks);
        if (oo == null) {
            LOGGER.trace("WHEN_IN_FOCUSED_WINDOW input map object not found; trying alt");
            im = this.pframe_.getRootPane().getInputMap(1);
        }
        if (oo == null) {
            LOGGER.trace("WHEN_ANCESTOR_OF_FOCUSED_COMPONENT input map object not found; bailing");
            return false;
        }
        ActionMap am = this.pframe_.getRootPane().getActionMap();
        Action aa = am.get(oo);
        if (aa == null) {
            LOGGER.trace("action not found, {}", (Object)this.pframe_.getName());
            return false;
        }
        LOGGER.trace("enabled? a {}", (Object)aa.isEnabled());
        if (!aa.isEnabled()) {
            return false;
        }
        if (aa instanceof AbstractAction) {
            EventQueue.invokeLater(() -> aa.actionPerformed(null));
        }
        return true;
    }
}

