/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.data.nc.exc.NcNotAuthorizedException;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public final class NcFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static URL createUrl(String address) {
        LOGGER.trace("{}", (Object)address);
        try {
            return new URL(address);
        }
        catch (MalformedURLException mue) {
            LOGGER.trace("MalformedURLException creating URL");
        }
        catch (Exception exc) {
            LOGGER.trace("{}} creating URL", (Object)exc.getClass().getSimpleName());
        }
        return null;
    }

    public static String getUrlFname(URL url) {
        String fname = null;
        try {
            fname = new File(url.getPath()).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fname == null) {
            String path = url.getFile();
            fname = path.substring(path.lastIndexOf(47) + 1);
        }
        return fname;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DatasetUrl createDatasetUrl(String address) {
        DatasetUrl durl;
        block7: {
            LOGGER.trace("{}", (Object)address);
            durl = null;
            try {
                durl = DatasetUrl.findDatasetUrl(address);
            }
            catch (HeadlessException hexc) {
                LOGGER.trace("Exception creating DatasetUrl: {}, {}", (Object)hexc.getMessage());
                throw new HeadlessException(hexc.getMessage());
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                LOGGER.trace("IOException creating DatasetUrl: {}", (Object)ioe.getMessage());
                if (msg.indexOf("authoriz") <= -1) {
                    // empty if block
                }
            }
            catch (Exception exc) {
                String msg = exc.getMessage();
                LOGGER.trace("Exception creating DatasetUrl: {}", (Object)exc.getMessage());
                if (msg.indexOf("authoriz") <= -1) break block7;
                throw new NcNotAuthorizedException();
            }
        }
        if (durl != null) {
            LOGGER.trace("Service type {}", (Object)durl.getServiceType());
            if (durl.getServiceType() == null) {
                // empty if block
            }
        }
        return durl;
    }

    public static String getDurlFname(DatasetUrl durl) {
        String fname = durl.getTrueurl();
        LOGGER.trace("true URL {}", (Object)fname);
        int qmark = fname.indexOf("?");
        if (qmark > -1) {
            fname = fname.substring(qmark + 1);
        }
        LOGGER.trace("after qmark {}", (Object)fname);
        int hash = fname.indexOf("#");
        if (hash > -1) {
            fname = fname.substring(0, hash);
        }
        LOGGER.trace("after hash {}", (Object)fname);
        int slash = fname.lastIndexOf("/");
        if (slash > -1 && slash != fname.length() - 1) {
            fname = fname.substring(slash + 1);
        }
        LOGGER.trace("after slash {}", (Object)fname);
        int colon = fname.indexOf(":");
        if (colon > -1) {
            fname = fname.substring(colon + 1);
        }
        return fname;
    }

    public static String getNameRoot(String fname) {
        String result = fname;
        String lcname = result.toLowerCase();
        for (String s : NcFilenameFilter.getExtensionsArray()) {
            if (!lcname.endsWith("." + s.toLowerCase())) continue;
            result = result.substring(0, result.length() - s.length() - 1);
            lcname = result.toLowerCase();
        }
        return result;
    }

    private NcFileUtils() {
    }
}

