/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatUgrid;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatUgrid
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcGridderLonLatUgrid() {
        this(100, 50);
    }

    public NcGridderLonLatUgrid(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatUgrid(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        LOGGER.trace("");
        this.prepareGridAxes();
        NcArrayLonLatUgrid nca = (NcArrayLonLatUgrid)((Object)a);
        boolean hasBad = a.hasBadValues();
        int numXs = nca.getLength();
        for (int i = 0; i < numXs; ++i) {
            double[][] corners;
            double lon0 = nca.longitudeAt(i);
            double lat0 = nca.latitudeAt(i);
            double value = nca.valueAt(i);
            if (lon0 > 720.0 || lon0 < -720.0 || Double.isNaN(lon0) || lat0 > 90.0 || lat0 < -90.0 || Double.isNaN(lat0) || hasBad && a.isMissingOrInvalid(value) || (corners = nca.cornerLonLats(i)) == null || corners.length < 3) continue;
            double lon1 = corners[0][0];
            double lon2 = corners[1][0];
            double lon3 = corners[2][0];
            double lat1 = corners[0][1];
            double lat2 = corners[1][1];
            double lat3 = corners[2][1];
            if (corners.length > 3) {
                double lon4 = corners[3][0];
                double lat4 = corners[3][1];
                this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
                continue;
            }
            this.triSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, value, target);
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        LOGGER.trace("unable to interpolate; pitching over to no-interpolated gridding");
        this.regridNoInterpolate(a, target);
    }
}

