/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.BinaryColorTable;
import java.awt.Color;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PalColorTable
extends BinaryColorTable {
    public PalColorTable() {
        this.initiateFixedSizeArray(256);
        for (int i = 0; i < 256; ++i) {
            float bright = (float)i / 255.0f;
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("PAL");
    }

    public PalColorTable(File f) throws IOException, FileNotFoundException {
        super(f, 768, 768);
    }

    public PalColorTable(URL url) throws IOException {
        super(url, 768, 768);
    }

    public PalColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PAL");
    }

    public static PalColorTable factory(SampleID id) {
        PalColorTable c = new PalColorTable();
        switch (id) {
            case GRAYSCALE: {
                for (int i = 0; i < 256; ++i) {
                    c.setColorAt(i, new Color(i, i, i));
                }
                c.setName("grayscale");
                break;
            }
            case BLUESCALE: {
                for (int i = 0; i < 256; ++i) {
                    c.setColorAt(i, new Color(i, i, 255));
                }
                c.setName("bluescale");
                break;
            }
            case HOTSTREAK: {
                int i;
                for (i = 0; i < 128; ++i) {
                    c.setColorAt(i, new Color(255, i * 2, 0));
                }
                for (i = 128; i < 256; ++i) {
                    c.setColorAt(i, new Color(255, 255, i * 2 - 256));
                }
                c.setName("hotstreak");
                break;
            }
            case OLDGLORY: {
                int blue;
                int green;
                int red;
                int i;
                for (i = 0; i < 128; ++i) {
                    red = 255;
                    blue = green = i * 2;
                    c.setColorAt(i, new Color(red, green, blue));
                }
                for (i = 128; i < 256; ++i) {
                    green = red = 511 - 2 * i;
                    blue = 255;
                    c.setColorAt(i, new Color(red, green, blue));
                }
                c.setName("oldglory");
                break;
            }
            case GAEA: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        green = red = i * 2;
                        blue = 153 + i;
                    } else {
                        red = 511 - 2 * i;
                        green = 408 - i;
                        blue = red;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    c.setColorAt(i, new Color(red, green, blue));
                }
                c.setName("gaea");
                break;
            }
            case CHRISTMAS: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        red = i * 2;
                        green = 153 + i;
                        blue = 51 + i * 2;
                    } else {
                        red = 255;
                        blue = green = 511 - 2 * i;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    c.setColorAt(i, new Color(red, green, blue));
                }
                c.setName("christmas");
                break;
            }
            case HOTMETAL: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        red = i * 2;
                        green = 0;
                        blue = 0;
                    } else {
                        red = 255;
                        green = (i - 127) * 2;
                        blue = 0;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    c.setColorAt(i, new Color(red, green, blue));
                }
                c.setName("hotmetal");
            }
        }
        c.setType("PAL");
        return c;
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        PalColorTable c = new PalColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[768];
        for (int i = 0; i < 256; ++i) {
            Color c = this.getColorAt(i);
            b[0 + i] = (byte)c.getRed();
            b[256 + i] = (byte)c.getGreen();
            b[512 + i] = (byte)c.getBlue();
        }
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws EOFException {
        if (b.length < 768) {
            throw new EOFException("Not a valid PAL color table");
        }
        this.initiateFixedSizeArray(256);
        for (int i = 0; i < 256; ++i) {
            this.setColorAt(i, new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
    }

    public static enum SampleID {
        GRAYSCALE,
        BLUESCALE,
        HOTSTREAK,
        OLDGLORY,
        GAEA,
        CHRISTMAS,
        HOTMETAL;

    }
}

