/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CantersPolyconicW31
extends ConcavePoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Canters Polyconic W31";
    public static final int PROPERTIES = 262176;
    public static final double MM = 0.90631;
    public static final double NN = 0.33333;
    public static final double KK = 1.46602;
    public static final double CSUBX = 2.93204 / Math.sqrt(0.3021003123);
    public static final double CSUBY = 2.0 / (1.46602 * Math.sqrt(0.3021003123));
    private static final double CP1 = 1.0099;
    private static final double CP3 = -0.0227;
    private static final double CP5 = -0.0051;
    private static final double THREE_CP3 = -0.06810000000000001;
    private static final double FIVE_CP5 = -0.025500000000000002;
    private static final double MAX_X_OVER_RS = 0.5 * CSUBX / 1.0099;
    private static final double MAX_Y_OVER_RS = 1.358889;

    public CantersPolyconicW31(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconicW31(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 262176, width, height, xmargin, ymargin, MAX_X_OVER_RS, 1.358889);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double sinPsi = 0.90631 * Math.sin(phiRad);
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double cosNLambda = Math.cos(0.33333 * absLambdaRad);
        double cosDelta = cosNLambda * cosPsi;
        double sinDelta = Math.sqrt(1.0 - cosDelta * cosDelta);
        double deltaRad = Math.acos(cosDelta);
        double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
        double cosAlpha = sinPsi / sinDelta;
        double sinAlpha = Math.sqrt(1.0 - cosAlpha * cosAlpha);
        double capX = CSUBX * sinDeltaOver2 * sinAlpha;
        double capY = CSUBY * sinDeltaOver2 * cosAlpha;
        double capY2 = capY * capY;
        double capY4 = capY2 * capY2;
        double yp = (1.0099 + -0.0227 * capY2 + -0.0051 * capY4) * capY;
        double dyp = 1.0099 + -0.06810000000000001 * capY2 + -0.025500000000000002 * capY4;
        double xp = lambdaRad >= 0.0 ? capX / dyp : -capX / dyp;
        double x = (double)this.outCenterX_ + xp * this.rS_;
        double y = (double)this.outCenterY_ - yp * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double dyp;
        double xp;
        double capX;
        double[] lambdaPhiRad;
        double capY4;
        double capY2;
        double absYOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absy > this.ymRS_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double yp = absYOverRS = absy * this.invRS_;
        double capY = 1.5707963267948966 * yp / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            capY2 = capY * capY;
            capY4 = capY2 * capY2;
            double func = (1.0099 + -0.0227 * capY2 + -0.0051 * capY4) * capY;
            double dfunc = 1.0099 + -0.06810000000000001 * capY2 + -0.025500000000000002 * capY4;
            double dCapY = -(func - yp) / dfunc;
            capY += dCapY;
            if (Math.abs(dCapY) < 1.0E-5) break;
        }
        if ((lambdaPhiRad = this.transformXY2LambdaPhiRad(capX = (xp = absXOverRS) * (dyp = 1.0099 + -0.06810000000000001 * (capY2 = capY * capY) + -0.025500000000000002 * (capY4 = capY2 * capY2)), capY)) == null || Double.isNaN(lambdaPhiRad[0]) || Double.isNaN(lambdaPhiRad[1]) || lambdaPhiRad[0] > Math.PI || lambdaPhiRad[1] > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaPhiRad[0]);
        double phi = Math.signum(y) * Math.toDegrees(lambdaPhiRad[1]);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPolyconicW31 cantersPolyconicW31 = this;
        synchronized (cantersPolyconicW31) {
            double y;
            double capY = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double capY4;
                double capY2;
                double yp = y * this.invRS_;
                capY += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    capY2 = capY * capY;
                    capY4 = capY2 * capY2;
                    double func = (1.0099 + -0.0227 * capY2 + -0.0051 * capY4) * capY;
                    double dfunc = 1.0099 + -0.06810000000000001 * capY2 + -0.025500000000000002 * capY4;
                    double dCapY = -(func - yp) / dfunc;
                    capY += dCapY;
                    if (Math.abs(dCapY) < 1.0E-5) break;
                }
                capY2 = capY * capY;
                capY4 = capY2 * capY2;
                double dyp = 1.0099 + -0.06810000000000001 * capY2 + -0.025500000000000002 * capY4;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xp = x * this.invRS_;
                    double capX = xp * dyp;
                    double[] lambdaPhiRad = this.transformXY2LambdaPhiRad(capX, capY);
                    if (lambdaPhiRad == null || Double.isNaN(lambdaPhiRad[0])) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaPhiRad[0]), Math.toDegrees(lambdaPhiRad[1]));
                }
            }
        }
    }

    private double[] transformXY2LambdaPhiRad(double capX, double capY) {
        double xOverCx = capX / CSUBX;
        double yOverCy = capY / CSUBY;
        double sinDeltaOver2 = Math.hypot(xOverCx, yOverCy);
        if (sinDeltaOver2 < 1.0E-5) {
            return new double[]{0.0, 0.0};
        }
        double cosAlpha = yOverCy / sinDeltaOver2;
        double delta = 2.0 * Math.asin(sinDeltaOver2);
        double sinPsi = cosAlpha * Math.sin(delta);
        double phiRad = Math.asin(sinPsi / 0.90631);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(capX) < 1.0E-5) {
            return new double[]{0.0, phiRad};
        }
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double lambdaRad = 3.000030000300003 * Math.acos(Math.cos(delta) / cosPsi);
        if (lambdaRad > Math.PI) {
            return null;
        }
        if (capX < 0.0) {
            lambdaRad = -lambdaRad;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

