/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eckert2
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Eckert II";
    public static final int PROPERTIES = 8200;
    public static final double SQRT_6PI = Math.sqrt(Math.PI * 6);
    public static final double INV_SQRT_6PI = 1.0 / SQRT_6PI;
    public static final double SQRT_2PI_OVER_3 = Math.sqrt(2.0943951023931953);
    public static final double SQRT_3_OVER_2PI = 1.0 / SQRT_2PI_OVER_3;
    private static final double MAX_X_OVER_RS = Math.PI * 4 * INV_SQRT_6PI;
    private static final double MAX_Y_OVER_RS = SQRT_2PI_OVER_3;

    public Eckert2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8200, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double sqrtFourM3SinPhi = Math.sqrt(4.0 - 3.0 * Math.sin(absPhiRad));
        double x = 2.0 * lambdaRad * sqrtFourM3SinPhi * INV_SQRT_6PI;
        double y = SQRT_2PI_OVER_3 * (2.0 - sqrtFourM3SinPhi);
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double sqrtFourM3SinPhi = 2.0 - absYOverRS * SQRT_3_OVER_2PI;
        double phiRad = Math.asin((4.0 - sqrtFourM3SinPhi * sqrtFourM3SinPhi) / 3.0);
        double lambdaRad = 0.5 * SQRT_6PI * absXOverRS / sqrtFourM3SinPhi;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert2 eckert2 = this;
        synchronized (eckert2) {
            double y;
            double yOverRS;
            double sqrtFourM3SinPhi;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin((4.0 - (sqrtFourM3SinPhi = 2.0 - (yOverRS = (y = (double)iy + 0.5) * this.invRS_) * SQRT_3_OVER_2PI) * sqrtFourM3SinPhi) / 3.0)) > 1.5707963267948966); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = 0.5 * SQRT_6PI * (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / sqrtFourM3SinPhi) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 2; ++i) {
            double lon = i == 0 ? this.lambdaC_ + 179.99999 : this.lambdaC_ - 179.99999;
            Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
            Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
            Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
            GraphicUtils.drawLine(g2d, dotN, dot0);
            GraphicUtils.drawLine(g2d, dot0, dotS);
        }
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0);
        GraphicUtils.drawLine(g2d, dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        GraphicUtils.drawLine(g2d, dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        if (dot0 == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        GraphicUtils.drawLine(g2d, dotN, dot0);
        GraphicUtils.drawLine(g2d, dot0, dotS);
    }
}

