/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FlowerProjection
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final double joinLat_;
    private final int numLobes_;
    private final double lobeWidth_;
    private final double halfLobeWidth_;

    public FlowerProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor, double joinLat, int numLobes) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        this.joinLat_ = joinLat;
        this.numLobes_ = numLobes;
        this.lobeWidth_ = 360.0 / (double)this.numLobes_;
        this.halfLobeWidth_ = 0.5 * this.lobeWidth_;
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    protected void setInvPoints(int ix, int iy, double dlambda, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + dlambda, lat);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - dlambda, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        LOGGER.trace("reference lon {}", (Object)this.lambdaC_);
        for (int i = 0; i < this.numLobes_; ++i) {
            double lon1 = this.lambdaC_ + (double)i * this.lobeWidth_ + 1.0E-5;
            double lon2 = this.lambdaC_ + (double)(i + 1) * this.lobeWidth_ - 1.0E-5;
            this.drawLobeMeridianBezier(g2d, lon1, 90.0);
            this.drawLobeMeridianBezier(g2d, lon2, 90.0);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat >= this.joinLat_) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_ + this.halfLobeWidth_, lat);
            if (dot == null) {
                return;
            }
            Point2D.Double np = this.transformLL2XYIgnoreMargins(0.0, 90.0);
            double dx = np.x - dot.x;
            double dy = np.y - dot.y;
            double r = Math.sqrt(dx * dx + dy * dy);
            Graphics2D g2x = (Graphics2D)g2d.create();
            g2x.translate(np.x, np.y);
            ProjGraphicUtils.drawEllipse(g2x, 0.0, 0.0, r, r);
            g2x.dispose();
        } else {
            for (int i = 0; i < this.numLobes_; ++i) {
                double lon1 = this.lambdaC_ + (double)i * this.lobeWidth_ + 1.0E-5;
                double lon2 = this.lambdaC_ + (double)i * this.lobeWidth_ + this.halfLobeWidth_;
                double lon3 = this.lambdaC_ + (double)(i + 1) * this.lobeWidth_ - 1.0E-5;
                Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
                Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
                Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
                GraphicUtils.drawCircularArc(g2d, dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        for (int i = 0; i < this.numLobes_; ++i) {
            double lobeCenter = MapUtils.normalizeMP180(this.lambdaC_ + (double)i * this.lobeWidth_ + this.halfLobeWidth_);
            double cdiff = Math.abs(MapUtils.normalizeMP180(lon - lobeCenter));
            if (cdiff > this.halfLobeWidth_) continue;
            Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            if (Math.abs(cdiff) < 1.0E-5) {
                GraphicUtils.drawLine(g2d, dotN, dotS);
                return;
            }
            Point2D.Double dotJoin = this.transformLL2XYIgnoreMargins(lon, this.joinLat_);
            GraphicUtils.drawLine(g2d, dotN, dotJoin);
            if (Math.abs(cdiff - this.halfLobeWidth_) < 1.0E-5) {
                return;
            }
            this.drawLobeMeridianBezier(g2d, lon, maxLat);
        }
    }

    private void drawLobeMeridianBezier(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        for (double lat = -maxLat; lat < this.joinLat_; lat += 0.5) {
            dot = this.transformLL2XYIgnoreMargins(lon, lat);
            ptlist.add(new Point2D.Double(dot.x, dot.y));
        }
        dot = this.transformLL2XY(lon, this.joinLat_);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        new Bezier(false, ptlist).draw(g2d);
    }
}

