/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hatano
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hatano";
    public static final int PROPERTIES = 8;
    private static final double CSUBX = 0.85;
    private static final double CSUBY = 1.758587;
    private static final double CSUBP = 2.675945;
    private static final double CSUBYA = 1.930519;
    private static final double CSUBPA = 2.437625;
    private static final double INV_CY = 0.5686383443071057;
    private static final double INV_CP = 0.3736997584031062;
    private static final double INV_CYA = 0.5179954198844974;
    private static final double INV_CPA = 0.41023537254499765;
    private static final double MAX_THETA = 48.18967443209006;
    private static final double MAX_THETAA = 41.40961606708636;
    private static final double MAX_THETA_RAD = Math.toRadians(48.18967443209006);
    private static final double MAX_THETAA_RAD = Math.toRadians(41.40961606708636);
    private static final double MAX_X_OVER_RS = 2.670353755551324;
    private static final double MAX_Y_OVER_RS = 1.758587 * Math.sin(MAX_THETA_RAD);
    private static final double MAX_YA_OVER_RS = 1.930519 * Math.sin(MAX_THETAA_RAD);
    private int dyMaxS_;
    private final ProjBooleanParameter asymmParam_ = new ProjBooleanParameter("Show asymmetric form", "Asymmetric", true);
    private boolean asymmetric_;

    public Hatano(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hatano(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.670353755551324, MAX_Y_OVER_RS);
        this.addParameter(this.asymmParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.asymmParam_)) {
            this.setAsymmetric(((ProjBooleanParameter)this.getParameter(0)).isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setAsymmetric(boolean b) {
        this.asymmetric_ = b;
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.dyMaxS_ = this.asymmetric_ ? -((int)(MAX_YA_OVER_RS * this.rS_ + 0.5)) : -this.dyMax_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double cSubP = this.asymmetric_ && lat < 0.0 ? 2.437625 : 2.675945;
        double cSubY = this.asymmetric_ && lat < 0.0 ? 1.930519 : 1.758587;
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double cpSinPhi = cSubP * sinPhi;
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - cpSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = cSubY * Math.sin(thetaRad);
        double x = 0.85 * this.lonToLambdaRad(lon) * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (y < (double)this.dyMaxS_) {
            return null;
        }
        double invCp = this.asymmetric_ && y < 0.0 ? 0.41023537254499765 : 0.3736997584031062;
        double yOverRS = y * this.invRS_;
        double invCy = this.asymmetric_ && y < 0.0 ? 0.5179954198844974 : 0.5686383443071057;
        double sinTheta = yOverRS * invCy;
        double thetaRad = Math.asin(sinTheta);
        double twoThetaRad = 2.0 * thetaRad;
        double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * invCp;
        double phiRad = Math.asin(sinPhi);
        if (Double.isNaN(phiRad)) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double lambdaRad = xOverRS / (0.85 * Math.cos(thetaRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hatano hatano = this;
        synchronized (hatano) {
            for (int iy = this.dyMaxS_; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                if (y < (double)this.dyMaxS_) continue;
                double invCp = this.asymmetric_ && y < 0.0 ? 0.41023537254499765 : 0.3736997584031062;
                double invCy = this.asymmetric_ && y < 0.0 ? 0.5179954198844974 : 0.5686383443071057;
                double yOverRS = y * this.invRS_;
                double sinTheta = yOverRS * invCy;
                double thetaRad = Math.asin(sinTheta);
                double twoThetaRad = 2.0 * thetaRad;
                double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * invCp;
                double phiRad = Math.asin(sinPhi);
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (0.85 * Math.cos(thetaRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void setInvPoints(int ix, int iy, double dlambda, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + dlambda, lat);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - dlambda, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawMeridianNoLabel(g2d, this.lambdaC_ - 179.99999, 90.0);
        this.drawMeridianNoLabel(g2d, this.lambdaC_ + 179.99999, 90.0);
        Point2D.Double npl = this.transformLL2XY(this.lambdaC_ - 179.99999, 90.0);
        Point2D.Double npr = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0);
        Point2D.Double spl = this.transformLL2XY(this.lambdaC_ - 179.99999, -90.0);
        Point2D.Double spr = this.transformLL2XY(this.lambdaC_ + 179.99999, -90.0);
        GraphicUtils.drawLine(g2d, npl, npr);
        GraphicUtils.drawLine(g2d, spl, spr);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (absLambdaRad < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            double rectX;
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            double rectW = 1.7 * absLambdaRad * this.rS_;
            double d = rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            if (this.asymmetric_) {
                double rectH = 3.517174 * this.rS_;
                double rectY = (double)this.outCenterY_ - 1.758587 * this.rS_;
                if (lambdaRad > 0.0) {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotEq, dotN);
                } else {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotEq);
                }
                rectH = 3.861038 * this.rS_;
                rectY = (double)this.outCenterY_ - 1.930519 * this.rS_;
                if (lambdaRad > 0.0) {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotEq);
                } else {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotEq, dotS);
                }
            } else {
                double rectH = 3.517174 * this.rS_;
                double rectY = (double)this.outCenterY_ - 1.758587 * this.rS_;
                if (lambdaRad > 0.0) {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotN);
                } else {
                    GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotS);
                }
            }
        }
    }
}

