/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransverseMercator
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Transverse Mercator (Sphere)";
    public static final int PROPERTIES = 0x601000;
    private static final double DEFAULT_HEIGHT = 10.0;
    private static final double DEFAULT_K0 = 0.9996;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.log(Math.tan(0.8726646259971648));
    private double height_ = 10.0;
    private double k0RS_ = 1.0;
    private double invK0RS_ = 1.0;
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Height", "\u00b0", 10.0, 0.002, 60.0, true, true);

    public TransverseMercator(int width, int height) {
        this(width, height, 0, 0);
    }

    public TransverseMercator(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x601000, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        this.addParameter(this.hgtParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.hgtParam_)) {
            this.setHeight(this.hgtParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setHeight(double height) {
        this.height_ = height;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double halfHRad = Math.toRadians(0.5 * this.height_);
        double heightFactor = 0.9996 * halfHRad;
        this.setMaxXYOverRS(2.0 * heightFactor, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        this.k0RS_ = 0.9996 * this.rS_;
        this.invK0RS_ = 1.0 / this.k0RS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double b = Math.cos(phiRad) * Math.sin(lambdaRad);
        if (Math.abs(b) >= 0.95) {
            return null;
        }
        double x = 0.5 * Math.log((1.0 + b) / (1.0 - b));
        double y = Math.atan2(Math.tan(phiRad), Math.cos(lambdaRad)) - this.phiCRad_;
        x = (double)this.outCenterX_ + x * this.k0RS_;
        y = (double)this.outCenterY_ - y * this.k0RS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double d = y * this.invK0RS_ + this.phiCRad_;
        double xOverK0RS = x * this.invK0RS_;
        double phiRad = Math.asin(Math.sin(d) / Math.cosh(xOverK0RS));
        double lambdaRad = Math.atan2(Math.sinh(xOverK0RS), Math.cos(d));
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TransverseMercator transverseMercator = this;
        synchronized (transverseMercator) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double d = y * this.invK0RS_ + this.phiCRad_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double phiRad = Math.asin(Math.sin(d) / Math.cosh(x * this.invK0RS_));
                    double lambdaRad = Math.atan2(Math.sinh(x * this.invK0RS_), Math.cos(d));
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    public LonLatEdges getBounds() {
        double dlon2;
        double dlon1;
        double lat;
        PointLL ll;
        double wOver2 = 0.5 * (double)this.getWidth();
        double hOver2 = 0.5 * (double)this.getHeight();
        double tLat = -9999.0;
        double bLat = 9999.0;
        if (this.transformLL2XY(0.0, 90.0) != null) {
            tLat = 90.0;
        }
        if (this.transformLL2XY(0.0, -90.0) != null) {
            bLat = -90.0;
        }
        int j1 = 0;
        int j2 = 0;
        int j = 0;
        while ((double)j < hOver2) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j1 = j;
                break;
            }
            ++j;
        }
        j = this.getHeight() - 1;
        while ((double)j > hOver2) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j2 = j;
                break;
            }
            --j;
        }
        double dlon = 0.0;
        if (tLat < 90.0 && bLat > -90.0) {
            double r = Math.abs((double)j1 - hOver2);
            for (int i = 5; i < 90; i += 5) {
                double rCos = r * Math.cos(Math.toRadians(i));
                double rSin = r * Math.sin(Math.toRadians(i));
                PointLL ll1 = this.transformXY2LL(wOver2 + rCos - 1.0, hOver2 + rSin - 1.0);
                PointLL ll2 = this.transformXY2LL(wOver2 - rCos + 1.0, hOver2 - rSin + 1.0);
                dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ > ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            }
        }
        int i = 0;
        while ((double)i < wOver2) {
            double lat2;
            PointLL ll1 = this.transformXY2LL(wOver2 + (double)i, (double)j1 + 0.5);
            PointLL ll2 = this.transformXY2LL(wOver2 + (double)i, (double)j2 + 0.5);
            if (ll1 == null && ll2 == null) break;
            if (ll1 == null) {
                dlon1 = 0.0;
            } else {
                lat2 = ll1.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon1 = this.lambdaC_ > ll1.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll1.getLon());
            }
            if (ll2 == null) {
                dlon2 = 0.0;
            } else {
                lat2 = ll2.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon2 = this.lambdaC_ > ll2.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll2.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll2.getLon());
            }
            dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            ++i;
        }
        double dlat = Math.max(Math.abs(this.phiC_ - tLat), Math.abs(this.phiC_ - bLat));
        double llTop = Math.min(90.0, tLat);
        double llBottom = Math.max(-90.0, bLat);
        if (tLat > 89.5 || bLat < -89.5 || dlon > 180.0) {
            dlon = 180.0;
        } else {
            PointLL ll1;
            dlon = Math.max(dlon, dlat);
            int i1 = 0;
            int i2 = 0;
            while ((double)i2 < wOver2) {
                ll1 = this.transformXY2LL(i2, hOver2);
                if (ll1 != null) {
                    dlon1 = this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon());
                    dlon = Math.max(dlon, dlon1);
                    i1 = i2;
                    break;
                }
                ++i2;
            }
            int j3 = 0;
            while ((double)j3 < hOver2) {
                ll1 = this.transformXY2LL(i1, hOver2 - (double)j3 + 0.5);
                PointLL ll2 = this.transformXY2LL(i1, hOver2 + (double)j3 + 0.5);
                if (ll1 == null && ll2 == null) break;
                dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
                ++j3;
            }
        }
        double llLeft = this.lambdaC_ - dlon;
        double llRight = this.lambdaC_ + dlon;
        if (llRight - llLeft > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else if (llLeft < -180.0) {
            llLeft += 360.0;
            llRight += 360.0;
        }
        return new LonLatEdges(llLeft, llTop, llRight, llBottom);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }
}

