/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.QuadEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class VanDerGrinten2
extends QuadEllipseProjection {
    public static final String PROJECTION_NAME = "Van der Grinten II";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double rhoBorder_;
    private double rhoBorder2_;

    public VanDerGrinten2(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absLat = Math.abs(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-5) {
            double x = lambdaRad;
            double y = 0.0;
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        if (absLat > 89.99999) {
            double x = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double phiRad = Math.toRadians(absLat);
        double b = phiRad * 0.6366197723675814;
        double c = Math.sqrt(1.0 - b * b);
        if (lambdaRad == 0.0) {
            double y1 = b / (1.0 + c);
            double x = 0.0;
            double y = Math.PI * y1;
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
        double a2 = a * a;
        double b2 = b * b;
        double c2 = c * c;
        double x1 = (c * Math.sqrt(1.0 + a2) - a * c2) / (1.0 + a2 * b2);
        double x = Math.PI * x1;
        double y = Math.PI * Math.sqrt(1.0 - x1 * (x1 + 2.0 * a));
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x1;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double xOverRS = Math.abs(x) * this.invRS_;
        double yOverRS = Math.abs(y) * this.invRS_;
        double y1 = yOverRS * 0.3183098861837907;
        double a = -(y1 * y1 - 1.0 + (x1 = xOverRS * 0.3183098861837907) * x1) / (2.0 * x1);
        double lambdaRad = VanDerGrinten2.iterateLambdaRad(a);
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = this.iteratePhiRad(x1, a);
        if (Double.isNaN(phiRad)) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten2 vanDerGrinten2 = this;
        synchronized (vanDerGrinten2) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x1;
                double a;
                double lambdaRad;
                double x;
                double rho2;
                double y = (double)iy + 0.5;
                double y1 = y * this.invRS_ * 0.3183098861837907;
                double y1Sq = y1 * y1;
                for (int ix = 0; !(ix >= this.dxMax_ || (rho2 = (x = (double)ix + 0.5) * x + y * y) > this.rhoBorder2_ || Double.isNaN(lambdaRad = VanDerGrinten2.iterateLambdaRad(a = -(y1Sq - 1.0 + (x1 = Math.abs(x) * this.invRS_ * 0.3183098861837907) * x1) / (2.0 * x1))) || lambdaRad > Math.PI); ++ix) {
                    double phiRad = this.iteratePhiRad(x1, a);
                    if (Double.isNaN(phiRad)) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double iterateLambdaRad(double a) {
        double twoA = 2.0 * a;
        double lambdaRad = a < 3.0 ? 0.7853981633974483 : (a < 14.0 ? 0.19634954084936207 : 0.0015707963267948967);
        for (int iter = 0; iter < 33; ++iter) {
            double func = Math.PI / lambdaRad - lambdaRad * 0.3183098861837907 - twoA;
            double dfunc = -Math.PI / (lambdaRad * lambdaRad) - 0.3183098861837907;
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }

    private double iteratePhiRad(double x1, double a) {
        double dcDphi;
        double dfunc;
        double b2;
        double c2;
        double func;
        double dphiRad;
        double a2 = a * a;
        double sqrt1plusA2 = Math.sqrt(1.0 + a2);
        double phiRad = 0.7853981633974483;
        double b = 0.0;
        double c = 0.0;
        double numer = 0.0;
        double denom = 0.0;
        double dbDphi = 0.6366197723675814;
        for (int iter = 0; iter < 33 && !Double.isNaN(phiRad += (dphiRad = -(func = (numer = (c = Math.sqrt(1.0 - (b = phiRad * 0.6366197723675814) * b)) * sqrt1plusA2 - a * (c2 = c * c)) / (denom = 1.0 + a2 * (b2 = b * b)) - x1) / (dfunc = (sqrt1plusA2 - 2.0 * a * c) * (dcDphi = 0.5 / c * (-2.0 * b * dbDphi)) / denom - numer / (denom * denom) * a2 * 2.0 * b * dbDphi))); ++iter) {
            if (phiRad >= 1.5707963267948966) {
                phiRad = 1.5607963267948965;
            }
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.rhoBorder_, this.outCenterY_, (double)this.outCenterX_ + this.rhoBorder_, this.outCenterY_);
        } else {
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_, lat);
            Point2D.Double dot3 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }
}

