/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.panoply.action.PanShowPlotTabAction;
import gov.nasa.giss.panoply.action.PanToggleSourcesEnhancedAction;
import gov.nasa.giss.panoply.action.PanToggleSourcesInfoAction;
import gov.nasa.giss.panoply.action.PanToggleToolBarLabelsAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotUnifiedPseudoPalette;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanBookmarksPanel;
import gov.nasa.giss.panoply.sources.PanCatalogsPanel;
import gov.nasa.giss.panoply.sources.PanDnVPanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.menu.GissRadioButtonMenuItem;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanViewMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JCheckBoxMenuItem miShowLabels_;
    private final JRadioButtonMenuItem miShowDatasets_;
    private final JRadioButtonMenuItem miShowCatalogs_;
    private final JRadioButtonMenuItem miShowBookmarks_;
    private final JRadioButtonMenuItem miGeoreferenced_;
    private final JRadioButtonMenuItem miPlottable_;
    private final JRadioButtonMenuItem miAllVars_;
    private final JCheckBoxMenuItem miShowInfo_;
    private final JCheckBoxMenuItem miShowEnhanced_;
    private final JMenuItem miControlsCenter_;
    private final JMenuItem miControlsTogglePalette_;
    private final JMenuItem miControlsNext_;
    private final JMenuItem miControlsPrev_;

    public PanViewMenu(PanFrame parent) {
        super(parent, "view-menu");
        boolean parentIsSources = parent instanceof PanSourcesFrame;
        PanToggleToolBarLabelsAction a = null;
        if (parentIsSources) {
            a = PanToggleToolBarLabelsAction.getSharedInstance();
        }
        this.miShowLabels_ = this.makeCheckBoxItemFromProperties("toggle-toolbar-labels", a);
        this.add(this.miShowLabels_).setEnabled(parentIsSources);
        this.addSeparator();
        AbstractAction a1 = null;
        AbstractAction a2 = null;
        AbstractAction a3 = null;
        if (parentIsSources) {
            final PanSourcesFrame sframe = (PanSourcesFrame)parent;
            a1 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.DATASETS);
                }
            };
            a2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.CATALOGS);
                }
            };
            a3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.BOOKMARKS);
                }
            };
        }
        this.miShowDatasets_ = this.makeRadioButtonItemFromProperties("show-datasets", a1);
        this.miShowCatalogs_ = this.makeRadioButtonItemFromProperties("show-catalogs", a2);
        this.miShowBookmarks_ = this.makeRadioButtonItemFromProperties("show-bookmarks", a3);
        this.add(this.miShowDatasets_).setEnabled(parentIsSources);
        this.add(this.miShowCatalogs_).setEnabled(parentIsSources);
        this.add(this.miShowBookmarks_).setEnabled(parentIsSources);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.miShowDatasets_);
        bgroup.add(this.miShowCatalogs_);
        bgroup.add(this.miShowBookmarks_);
        this.miShowDatasets_.setSelected(parentIsSources);
        this.addSeparator();
        a1 = null;
        a2 = null;
        a3 = null;
        if (parentIsSources) {
            a1 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewMenu.this.setVisibleVarClass(NcVarVisibility.GEOREF);
                }
            };
            a2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewMenu.this.setVisibleVarClass(NcVarVisibility.GRIDDABLE);
                }
            };
            a3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewMenu.this.setVisibleVarClass(NcVarVisibility.ALL);
                }
            };
        }
        this.miGeoreferenced_ = this.makeRadioButtonItemFromProperties("show-georeferenced-vars", a1);
        this.miPlottable_ = this.makeRadioButtonItemFromProperties("show-plottable-vars", a2);
        this.miAllVars_ = this.makeRadioButtonItemFromProperties("show-all-vars", a3);
        this.add(this.miGeoreferenced_).setEnabled(parentIsSources);
        this.add(this.miPlottable_).setEnabled(parentIsSources);
        this.add(this.miAllVars_).setEnabled(parentIsSources);
        bgroup = new ButtonGroup();
        bgroup.add(this.miGeoreferenced_);
        bgroup.add(this.miPlottable_);
        bgroup.add(this.miAllVars_);
        this.addSeparator();
        a1 = null;
        if (parentIsSources) {
            a1 = PanToggleSourcesInfoAction.getSharedInstance();
        }
        this.miShowInfo_ = this.makeCheckBoxItemFromProperties("toggle-info", a1);
        this.add(this.miShowInfo_).setEnabled(parentIsSources);
        if (PanUtils.isBeta()) {
            PanToggleSourcesEnhancedAction a22 = null;
            if (parentIsSources) {
                a22 = PanToggleSourcesEnhancedAction.getSharedInstance();
            }
            this.miShowEnhanced_ = this.makeCheckBoxItemFromProperties("toggle-enhanced-mode", a22);
            this.add(this.miShowEnhanced_).setEnabled(parentIsSources);
        } else {
            this.miShowEnhanced_ = null;
        }
        this.addSeparator();
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanShowPlotTabAction a12 = null;
        PanShowPlotTabAction a23 = null;
        PanShowPlotTabAction a32 = null;
        if (parentIsPlot) {
            PanPlotFrame pframe = (PanPlotFrame)parent;
            a12 = new PanShowPlotTabAction(pframe, "show-plot", 0);
            a23 = new PanShowPlotTabAction(pframe, "show-array-1", 1);
            a32 = new PanShowPlotTabAction(pframe, "show-array-2", 2);
        }
        GissRadioButtonMenuItem mi1 = this.makeRadioButtonItemFromProperties("show-plot", a12);
        GissRadioButtonMenuItem mi2 = this.makeRadioButtonItemFromProperties("show-array-1", a23);
        GissRadioButtonMenuItem mi3 = this.makeRadioButtonItemFromProperties("show-array-2", a32);
        this.add(mi1).setEnabled(parentIsPlot);
        this.add(mi2).setEnabled(parentIsPlot);
        this.add(mi3).setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(mi1);
        bg.add(mi2);
        bg.add(mi3);
        if (PanPlotControlsMeta.isFloating() && !PanPlotControlsMeta.isUnified()) {
            this.addSeparator();
            this.miControlsCenter_ = this.makeItemFromProperties("center-plot-controls", null);
            this.add(this.miControlsCenter_).setEnabled(false);
            this.miControlsNext_ = null;
            this.miControlsPrev_ = null;
            this.miControlsTogglePalette_ = null;
        } else {
            this.addSeparator();
            this.miControlsNext_ = this.makeItemFromProperties("show-next-plot-controls", null);
            this.miControlsPrev_ = this.makeItemFromProperties("show-prev-plot-controls", null);
            this.miControlsCenter_ = this.makeItemFromProperties("center-plot-controls", null);
            this.add(this.miControlsNext_).setEnabled(false);
            this.add(this.miControlsPrev_).setEnabled(false);
            this.add(this.miControlsCenter_).setEnabled(false);
            if (PanPlotControlsMeta.isFloating()) {
                this.miControlsTogglePalette_ = null;
            } else {
                this.miControlsTogglePalette_ = this.makeItemFromProperties("toggle-pseudo-palette", null);
                this.add(this.miControlsTogglePalette_).setEnabled(false);
            }
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean parentIsSources = this.pframe_ instanceof PanSourcesFrame;
        if (parentIsSources) {
            boolean showLabels = prefs.getBoolean("sources:toolbar.labels");
            PanSourcesPanel vsp = ((PanSourcesFrame)this.pframe_).getVisibleSubpanel();
            boolean isDatasets = vsp instanceof PanDnVPanel;
            boolean isCatalogs = vsp instanceof PanCatalogsPanel;
            boolean isBookmarks = vsp instanceof PanBookmarksPanel;
            this.miShowLabels_.setSelected(showLabels);
            this.miShowDatasets_.setSelected(isDatasets);
            this.miShowCatalogs_.setSelected(isCatalogs);
            this.miShowBookmarks_.setSelected(isBookmarks);
            this.miGeoreferenced_.setEnabled(isDatasets);
            this.miPlottable_.setEnabled(isDatasets);
            this.miAllVars_.setEnabled(isDatasets);
            if (isDatasets) {
                String vclass = prefs.getString("sources:datasets.varclass");
                this.miGeoreferenced_.setSelected(NcVarVisibility.GEOREF.matches(vclass));
                this.miPlottable_.setSelected(NcVarVisibility.GRIDDABLE.matches(vclass));
                this.miAllVars_.setSelected(NcVarVisibility.ALL.matches(vclass));
            }
            if (this.miShowInfo_ != null) {
                boolean isOn = prefs.getBoolean("sources:info.vis");
                this.miShowInfo_.setEnabled(isDatasets || isCatalogs);
                this.miShowInfo_.setSelected(isOn);
            }
            if (this.miShowEnhanced_ != null) {
                boolean isOn = prefs.getBoolean("sources:info.enhanced");
                this.miShowEnhanced_.setEnabled(isDatasets);
                this.miShowEnhanced_.setSelected(isOn);
            }
        }
        if (this.pframe_ instanceof PanPlotFrame) {
            PanPlotFrame pframe = (PanPlotFrame)this.pframe_;
            if (this.miControlsCenter_ != null && this.miControlsCenter_.getAction() != null) {
                if (pframe.isAnimating()) {
                    this.miControlsCenter_.getAction().setEnabled(false);
                } else {
                    this.miControlsCenter_.getAction().setEnabled(true);
                }
            }
            if (!PanPlotControlsMeta.isFloating() || PanPlotControlsMeta.isUnified()) {
                boolean enabled;
                PanPlotUnifiedPseudoPalette upp = pframe.getPseudoPalette();
                boolean bl = enabled = upp != null || pframe.areControlsVisible(PanPlotControlsID.UNIFIED);
                if (this.miControlsNext_ != null && this.miControlsNext_.getAction() != null) {
                    if (pframe.isAnimating()) {
                        this.miControlsNext_.getAction().setEnabled(false);
                        this.miControlsPrev_.getAction().setEnabled(false);
                    } else if (upp != null && !upp.isExpanded()) {
                        this.miControlsNext_.getAction().setEnabled(false);
                        this.miControlsPrev_.getAction().setEnabled(false);
                    } else {
                        this.miControlsNext_.getAction().setEnabled(enabled);
                        this.miControlsPrev_.getAction().setEnabled(enabled);
                    }
                }
                if (this.miControlsTogglePalette_ != null && this.miControlsTogglePalette_.getAction() != null) {
                    if (pframe.isAnimating()) {
                        this.miControlsTogglePalette_.getAction().setEnabled(false);
                    } else if (upp == null) {
                        this.miControlsTogglePalette_.getAction().setEnabled(false);
                    } else {
                        this.miControlsTogglePalette_.getAction().setEnabled(true);
                        String s = upp.isExpanded() ? PanProperties.MENU_PROPS.getString("collapse-pseudo-palette") : PanProperties.MENU_PROPS.getString("toggle-pseudo-palette");
                        this.miControlsTogglePalette_.setText(s);
                    }
                }
            }
        }
    }

    private void setVisibleVarClass(NcVarVisibility vclass) {
        if (this.pframe_ instanceof PanSourcesFrame) {
            PanSourcesFrame sframe = (PanSourcesFrame)this.pframe_;
            PanDnVPanel dp = (PanDnVPanel)sframe.getSubpanel(PanSourcesFrame.Subpanel.DATASETS);
            dp.setVisibleVarClass(vclass);
            sframe.showSubpanel(PanSourcesFrame.Subpanel.DATASETS);
        }
    }
}

