/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.ui.windoid.Windoid;
import gov.nasa.giss.ui.windoid.WindoidHeader;
import gov.nasa.giss.ui.windoid.WindoidHeaderMouseListener;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotWindoidHeaderMouseListener
implements WindoidHeaderMouseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotFrame mapframe_;
    private PanPlotControlsID cid_;
    private WindoidHeader header_;
    private boolean dragInProgress_;
    private Point pressPt_;
    private Point windoidPt_;
    private Point mousePt_;
    private long lastClick_;
    private boolean finishingClick_;

    public PanPlotWindoidHeaderMouseListener(PanPlotFrame parent, PanPlotControlsID cid, WindoidHeader header) {
        this.mapframe_ = parent;
        this.cid_ = cid;
        this.header_ = header;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        LOGGER.trace("{}", (Object)this.cid_);
        if (e == null) {
            LOGGER.trace("MouseEvent is null");
            return;
        }
        this.finishClick(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragInProgress_) {
            this.moveWindoid(e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(false);
            this.header_.setResizeHighlighted(false);
            this.header_.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.dragInProgress_) {
            this.header_.setCloseHighlighted(this.header_.isCloseable());
            this.header_.setResizeHighlighted(this.header_.isResizeable());
            this.header_.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e == null) {
            LOGGER.trace("MouseEvent is null");
            return;
        }
        this.pressPt_ = e.getPoint();
        if (this.header_.inCloseButton(this.pressPt_) || this.header_.inHideButton(this.pressPt_) || this.header_.inResizeButton(this.pressPt_)) {
            this.dragInProgress_ = false;
            return;
        }
        this.dragInProgress_ = true;
        Container windoid = this.header_.getTopLevelAncestor();
        if (windoid != null) {
            this.windoidPt_ = windoid.getLocation();
            this.mousePt_ = this.pressPt_;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragInProgress_) {
            this.moveWindoid(e.getPoint());
        } else {
            Point releasePt = e.getPoint();
            int dx = Math.abs(releasePt.x - this.pressPt_.x);
            int dy = Math.abs(releasePt.y - this.pressPt_.y);
            if (dx < 2 && dy < 2) {
                this.finishClick(e);
            }
        }
        this.dragInProgress_ = false;
    }

    private void moveWindoid(Point p) {
        if (!this.dragInProgress_) {
            return;
        }
        int dx = p.x - this.mousePt_.x;
        int dy = p.y - this.mousePt_.y;
        this.windoidPt_.translate(dx, dy);
        Container windoid = this.header_.getTopLevelAncestor();
        windoid.setLocation(this.windoidPt_);
    }

    private void finishClick(MouseEvent e) {
        if (this.finishingClick_) {
            return;
        }
        this.finishingClick_ = true;
        long now = System.currentTimeMillis();
        if (now - this.lastClick_ < 100L) {
            return;
        }
        Point pt = e.getPoint();
        if (this.header_.inCloseButton(pt)) {
            if (this.header_.isCloseable()) {
                if (this.cid_ != null) {
                    this.mapframe_.setControlsVisible(this.cid_, false);
                }
                if (this.mapframe_ != null && this.mapframe_.getPanMenuBar() != null) {
                    this.mapframe_.getPanMenuBar().refresh();
                }
            }
        } else if (!this.header_.inHideButton(pt) && !this.header_.inResizeButton(pt)) {
            if (e.getClickCount() == 2) {
                LOGGER.trace("double click");
                Windoid windoid = (Windoid)this.header_.getTopLevelAncestor();
                windoid.toggleCollapsed();
                PanPlotControlsMeta.putCollapsed(this.cid_, windoid.isCollapsed());
            } else if (e.getClickCount() == 1) {
                // empty if block
            }
        }
        this.lastClick_ = now;
        this.finishingClick_ = false;
    }
}

