/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.text.PrintfFormat;

public class PanArrayCubedSphereGMAOTableModel
extends PanArray2DTableModel {
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private final NcArrayLonLatCubedSphereGMAO ncaCS_;
    private final int faceCols_;
    private final int faceRows_;

    public PanArrayCubedSphereGMAOTableModel(NcArrayLonLatCubedSphereGMAO array) {
        super(array);
        this.ncaCS_ = array;
        this.faceCols_ = this.array_.getXAxis().getLength();
        this.faceRows_ = this.array_.getYAxis().getLength();
    }

    @Override
    public int getColumnCount() {
        return this.faceCols_;
    }

    @Override
    public int getRowCount() {
        return 6 * this.faceRows_;
    }

    @Override
    public String getColumnName(int col) {
        try {
            int colx;
            int n = colx = this.flippedLR_ ? this.faceCols_ - 1 - col : col;
            if (this.showCellIndex_) {
                return Integer.toString(colx + 1);
            }
            double val = this.array_.getXAxis().valueAt(colx);
            return PFORMAT_10G.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public String getRowName(int row) {
        try {
            int rowx = this.flippedBT_ ? 6 * this.faceRows_ - 1 - row : row;
            int face = rowx / this.faceRows_;
            int faceRow = rowx % this.faceRows_;
            if (this.showCellIndex_) {
                return "F" + (face + 1) + " - " + Integer.toString(faceRow + 1);
            }
            double val = this.array_.getYAxis().valueAt(faceRow);
            return "F" + (face + 1) + " - " + PFORMAT_10G.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            int rowx = this.flippedBT_ ? 6 * this.faceRows_ - 1 - row : row;
            int face = rowx / this.faceRows_;
            int faceRow = rowx % this.faceRows_;
            int colx = this.flippedLR_ ? this.faceCols_ - 1 - col : col;
            return this.valFormatter_.sprintfx(this.ncaCS_.valueAt(face, colx, faceRow));
        }
        catch (Exception ignore) {
            return "ERR";
        }
    }
}

