/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanColorContourPlotPrefsPanel
extends PanAbstractPrefsPanel {
    private static final String UP = "Up";
    private static final String DOWN = "Down";
    private PanIntSpinner xmajorDivSpinner_;
    private PanIntSpinner xminorDivSpinner_;
    private PanIntSpinner ymajorDivSpinner_;
    private PanIntSpinner yminorDivSpinner_;
    private StringComboBox xFormatCombo_;
    private StringComboBox yFormatCombo_;
    private StringComboBox yPositiveCombo_;
    private boolean refreshing_;

    public PanColorContourPlotPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Other Color Contour Plots"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a non-map color contour plot, set\u2026");
        this.xmajorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        this.xminorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        this.ymajorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        this.yminorDivSpinner_ = PanIntSpinner.create(2, 1, 20, 1);
        JLabel xdivLabel1 = new JLabel("Divisions: Major:\u2009");
        JLabel xdivLabel2 = new JLabel(", Minor:\u2009");
        JLabel ydivLabel1 = new JLabel("Divisions: Major:\u2009");
        JLabel ydivLabel2 = new JLabel(", Minor:\u2009");
        QuickBox xdivBox = QuickBox.createLeftBox(xdivLabel1, this.xmajorDivSpinner_, xdivLabel2, this.xminorDivSpinner_);
        QuickBox ydivBox = QuickBox.createLeftBox(ydivLabel1, this.ymajorDivSpinner_, ydivLabel2, this.yminorDivSpinner_);
        this.xFormatCombo_ = StringComboBox.createNumberPformat();
        this.yFormatCombo_ = StringComboBox.createNumberPformat();
        this.yPositiveCombo_ = StringComboBox.create();
        this.yPositiveCombo_.addItem(UP);
        this.yPositiveCombo_.addItem(DOWN);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 12, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)new JLabel("X Axis:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)xdivBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Tick Label Format:\u2009"), this.xFormatCombo_), new FGConstraint(1, ++row));
        this.add((Component)new JLabel("Y Axis:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)ydivBox, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Tick Label Format:\u2009"), this.yFormatCombo_), new FGConstraint(1, ++row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Treat Y axis as positive "), this.yPositiveCombo_, new JLabel(" if not apparent")), new FGConstraint(1, ++row));
    }

    private void attachListeners() {
        this.xmajorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.xaxis.div.major", this.xmajorDivSpinner_.getIntValue()));
        this.xminorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.xaxis.div.minor", this.xminorDivSpinner_.getIntValue()));
        this.ymajorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.yaxis.div.major", this.ymajorDivSpinner_.getIntValue()));
        this.yminorDivSpinner_.addChangeListener(e -> prefs_.setInt("plot:xy.yaxis.div.minor", this.yminorDivSpinner_.getIntValue()));
        this.xFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:xy.xaxis.tick.format", this.xFormatCombo_.getSelectedString());
        });
        this.yFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:xy.yaxis.tick.format", this.yFormatCombo_.getSelectedString());
        });
        this.yPositiveCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            boolean posup = this.yPositiveCombo_.getSelectedItem().equals(UP);
            prefs_.set("plot:xy.yaxis.posup", posup);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.xmajorDivSpinner_.setValue(prefs_.getInt("plot:xy.xaxis.div.major"));
        this.xminorDivSpinner_.setValue(prefs_.getInt("plot:xy.xaxis.div.minor"));
        this.ymajorDivSpinner_.setValue(prefs_.getInt("plot:xy.yaxis.div.major"));
        this.yminorDivSpinner_.setValue(prefs_.getInt("plot:xy.yaxis.div.minor"));
        this.xFormatCombo_.setSelectedItem(prefs_.getString("plot:xy.xaxis.tick.format"));
        this.yFormatCombo_.setSelectedItem(prefs_.getString("plot:xy.yaxis.tick.format"));
        if (prefs_.getBoolean("plot:xy.yaxis.posup")) {
            this.yPositiveCombo_.setSelectedItem(UP);
        } else {
            this.yPositiveCombo_.setSelectedItem(DOWN);
        }
        this.refreshing_ = false;
    }
}

