/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.symbol.SymbolID;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatOverlaysPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanOverlayComboBox[] overlayCombo_;
    private ColorComboBox[] colorCombo_;
    private JLabel[] weightLabel_;
    private PanIntSpinner[] weightSpinner_;
    private PanCheckBox[] maskInvertCB_;
    private DescribedEnumComboBox[] styleCombo_;
    private DescribedEnumComboBox[] symbolCombo_;
    private FloatComboBox[] symbolSizeCombo_;
    private JComponent[] maskRow_;
    private JComponent[] strokeRow_;
    private JComponent[] symbolRow_;
    private JComponent[] row3_;
    private boolean refreshing_;

    public PanLonLatOverlaysPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Overlay"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a map plot, set\u2026");
        this.overlayCombo_ = new PanOverlayComboBox[3];
        this.colorCombo_ = new ColorComboBox[3];
        this.weightLabel_ = new JLabel[3];
        this.weightSpinner_ = new PanIntSpinner[3];
        this.maskInvertCB_ = new PanCheckBox[3];
        this.styleCombo_ = new DescribedEnumComboBox[3];
        this.symbolCombo_ = new DescribedEnumComboBox[3];
        this.symbolSizeCombo_ = new FloatComboBox[3];
        this.row3_ = new JComponent[3];
        this.strokeRow_ = new JComponent[3];
        this.symbolRow_ = new JComponent[3];
        this.maskRow_ = new JComponent[3];
        this.setLayout(new BoxLayout(this, 1));
        this.add(QuickBox.createLeftBox(topText));
        this.add(Box.createVerticalStrut(8));
        for (int i = 0; i < 3; ++i) {
            this.add(QuickBox.createLeftBox(this.createSection(i)));
            if (i >= 2) continue;
            this.add(new JSeparator());
        }
    }

    private JPanel createSection(int idx) {
        JLabel oLabel = new JLabel("Overlay " + (idx + 1) + ":\u2009");
        this.overlayCombo_[idx] = PanOverlayComboBox.create(true);
        this.overlayCombo_[idx].setToolTipText("Select " + (idx + 1) + "st overlay to apply to new map plots");
        QuickBox row1 = QuickBox.createLeftBox(oLabel, this.overlayCombo_[idx]);
        JLabel blankLabel2 = new JLabel(" ");
        JLabel oColorLabel = new JLabel("Color:\u2009");
        this.colorCombo_[idx] = new ColorComboBox();
        this.weightLabel_[idx] = new JLabel("\u2014 Weight:\u2009");
        this.weightSpinner_[idx] = PanIntSpinner.weight(null, prefs_.getInt(PanParamKeys.P_OVERLAY_WGT[idx]), 0, 400);
        this.weightSpinner_[idx].setMaximumSize(this.weightSpinner_[idx].getPreferredSize());
        JLabel wgtPctLabel = new JLabel("%");
        QuickBox row2 = QuickBox.createLeftBox(blankLabel2, oColorLabel, this.colorCombo_[idx], this.weightLabel_[idx], this.weightSpinner_[idx], wgtPctLabel);
        JLabel blankLabel3a = new JLabel(" ");
        this.maskInvertCB_[idx] = PanCheckBox.create("Invert");
        this.maskRow_[idx] = QuickBox.createLeftBox(blankLabel3a, this.maskInvertCB_[idx]);
        JLabel blankLabel3b = new JLabel(" ");
        this.styleCombo_[idx] = new DescribedEnumComboBox(PanStrokePattern.class);
        this.styleCombo_[idx].setMaximumSize(this.styleCombo_[idx].getPreferredSize());
        this.strokeRow_[idx] = QuickBox.createLeftBox(blankLabel3b, new JLabel("Style:\u2009"), this.styleCombo_[idx]);
        JLabel blankLabel3c = new JLabel(" ");
        this.symbolCombo_[idx] = new DescribedEnumComboBox(SymbolID.class);
        this.symbolCombo_[idx].setName(PanParamKeys.P_OVERLAY_SYMBOL_ID[idx]);
        this.symbolCombo_[idx].removeItem(SymbolID.NONE);
        this.symbolSizeCombo_[idx] = FloatComboBox.create(2.0f, 16.0f);
        this.symbolCombo_[idx].setMaximumSize(this.symbolCombo_[idx].getPreferredSize());
        this.symbolSizeCombo_[idx].setMaximumSize(this.symbolSizeCombo_[idx].getPreferredSize());
        this.symbolRow_[idx] = QuickBox.createLeftBox(blankLabel3c, new JLabel("Symbol:\u2009"), this.symbolCombo_[idx], new JLabel("\u2014 Size:\u2009"), this.symbolSizeCombo_[idx]);
        this.row3_[idx] = QuickBox.createLeftBox(this.strokeRow_[idx]);
        GuiUtils.matchLabelWidths(oLabel, blankLabel2, blankLabel3a, blankLabel3b, blankLabel3c);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.add(row1);
        jp.add(Box.createVerticalStrut(1));
        jp.add(row2);
        jp.add(Box.createVerticalStrut(1));
        jp.add(this.row3_[idx]);
        jp.setOpaque(false);
        return jp;
    }

    private void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.overlayCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                String oname = (String)this.overlayCombo_[i].getSelectedItem();
                LOGGER.trace("combo {}, {}", (Object)PanParamKeys.P_OVERLAY_NAME[i], (Object)oname);
                prefs_.setString(PanParamKeys.P_OVERLAY_NAME[i], oname);
                this.refreshPrivate();
            });
            this.styleCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_STYLE[i], this.styleCombo_[i].getEnumName());
            });
            this.weightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParamKeys.P_OVERLAY_WGT[i], this.weightSpinner_[i].getIntValue());
            });
            this.maskInvertCB_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setBoolean(PanParamKeys.P_OVERLAY_INVERT[i], this.maskInvertCB_[i].isSelected());
            });
            this.colorCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_COLOR[i], this.colorCombo_[i].getSelectedColor());
            });
            this.symbolCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_OVERLAY_SYMBOL_ID[i], this.symbolCombo_[i].getEnumName());
            });
            this.symbolSizeCombo_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.setFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i], this.symbolSizeCombo_[i].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        LOGGER.trace("");
        this.refreshing_ = true;
        for (int i = 0; i < 3; ++i) {
            this.overlayCombo_[i].setSelectedItem(prefs_.getString(PanParamKeys.P_OVERLAY_NAME[i]));
            this.maskInvertCB_[i].setSelected(prefs_.getBoolean(PanParamKeys.P_OVERLAY_INVERT[i]));
            this.colorCombo_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_OVERLAY_COLOR[i]));
            this.weightSpinner_[i].setValue(prefs_.getInt(PanParamKeys.P_OVERLAY_WGT[i]));
            this.styleCombo_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_OVERLAY_STYLE[i]));
            this.symbolCombo_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_OVERLAY_SYMBOL_ID[i]));
            this.symbolSizeCombo_[i].setValue(prefs_.getFloat(PanParamKeys.P_OVERLAY_SYMBOL_SIZE[i]));
            MapOverlay oo = this.overlayCombo_[i].getSelectedOverlay();
            this.row3_[i].removeAll();
            this.weightLabel_[i].setText("\u2014 Weight:\u2009");
            if (oo == null) {
                this.row3_[i].add(this.strokeRow_[i]);
                this.row3_[i].add(Box.createHorizontalGlue());
                continue;
            }
            if (oo.isOutline()) {
                this.row3_[i].add(this.strokeRow_[i]);
                this.row3_[i].add(Box.createHorizontalGlue());
                continue;
            }
            if (oo.isPoints()) {
                this.row3_[i].add(this.symbolRow_[i]);
                this.row3_[i].add(Box.createHorizontalGlue());
                continue;
            }
            if (oo.isMask()) {
                this.weightLabel_[i].setText("\u2014 Opacity:\u2009");
                this.row3_[i].add(this.maskRow_[i]);
                this.row3_[i].add(Box.createHorizontalGlue());
                continue;
            }
            LOGGER.trace("overlay {} has unknown type, {}", (Object)i, (Object)oo.getClass().getSimpleName());
            this.row3_[i].add(this.strokeRow_[i]);
            this.row3_[i].add(Box.createHorizontalGlue());
        }
        this.refreshing_ = false;
    }
}

