/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotSizeFactor;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.task.Task;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCreatePlotTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final NcVariable ncvar_;
    private final Hashtable<PanCreatePlotOption, Object> options_;
    private String errMsg_;
    private PanPlotMeta pmeta_;

    public PanCreatePlotTask(NcVariable ncvar, Hashtable<PanCreatePlotOption, Object> options) {
        super("Creating plot");
        this.ncvar_ = ncvar;
        this.options_ = options;
    }

    @Override
    protected Object beginTask() {
        PanData data;
        long now = System.currentTimeMillis();
        PanPlotSizeFactor psize = (PanPlotSizeFactor)this.options_.get((Object)PanCreatePlotOption.SIZE_FACTOR);
        PanPlotType ptype = (PanPlotType)this.options_.get((Object)PanCreatePlotOption.PLOT_TYPE);
        int sizeFactor = psize == null ? PREFS.getInt("plot:size.factor") : psize.getSizeFactor();
        try {
            this.pmeta_ = new PanPlotMeta(ptype, sizeFactor);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception creating PanPlotMeta object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "Failed creating the plot manager: " + this.errMsg_;
            return null;
        }
        catch (Error err) {
            LOGGER.error("{} reported when creating PanPlotMeta", (Object)err.getClass().getSimpleName());
            this.errMsg_ = err.getClass().getSimpleName() + " occurred while creating the plot manager.";
            this.errMsg_ = this.errMsg_ + " Errors may recur. You should quit and restart Panoply.";
            return null;
        }
        if (this.pmeta_ == null) {
            LOGGER.warn("PanPlotMeta object is null despite lack of reported error.");
            this.errMsg_ = "The plot manager is null despite lack of reported error.";
            return null;
        }
        try {
            Object d1 = this.options_.containsKey((Object)PanCreatePlotOption.AXIS_INFO_1) ? this.options_.get((Object)PanCreatePlotOption.AXIS_INFO_1) : null;
            Object d2 = this.options_.containsKey((Object)PanCreatePlotOption.AXIS_INFO_2) ? this.options_.get((Object)PanCreatePlotOption.AXIS_INFO_2) : null;
            data = this.pmeta_.createData(this.ncvar_, d1, d2);
        }
        catch (NcException exc) {
            LOGGER.warn("NcException creating PanPlotData object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an exception preparing the data: " + this.errMsg_;
            LOGGER.error("{}", (Object)this.errMsg_);
            return null;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception creating PanPlotData object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an exception preparing the data: " + this.errMsg_;
            LOGGER.error("{}", (Object)this.errMsg_);
            return null;
        }
        catch (OutOfMemoryError err) {
            LOGGER.error("OutOfMemoryError reported when creating data handler");
            this.errMsg_ = "An out of memory error occurred while creating the plot data handler.";
            this.errMsg_ = this.errMsg_ + " Errors may recur. You should quit and restart Panoply.";
            return null;
        }
        catch (Error err) {
            LOGGER.error("{} reported when creating NcArray", (Object)err.getClass().getSimpleName());
            this.errMsg_ = err.getClass().getSimpleName() + " occurred while creating the plot data handler.";
            this.errMsg_ = this.errMsg_ + " Errors may recur. You should quit and restart Panoply.";
            return null;
        }
        if (data == null) {
            LOGGER.warn("PanData object is null despite lack of reported error.");
            this.errMsg_ = "Data handler is null despite lack of reported error.";
            return null;
        }
        try {
            data.getMinValue();
        }
        catch (Exception exc) {
            LOGGER.warn("Exception scanning data for min/max values: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an exception scanning the data for min/max values: " + this.errMsg_;
            return null;
        }
        try {
            this.pmeta_.createPlot();
        }
        catch (Exception exc) {
            LOGGER.warn("Exception creating PanPlot object: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an exception creating the plot object: " + this.errMsg_;
            return null;
        }
        try {
            if (data instanceof PanData1D) {
                ((PanData1D)data).valueAt(0, 0);
            } else if (data instanceof PanData2D) {
                ((PanData2D)data).valueAt(0, 0);
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Exception performing initial data gridding: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString().replaceFirst(".*: ", "");
            this.errMsg_ = "There was an exception performing initial data gridding: " + this.errMsg_;
        }
        LOGGER.trace("begin secs {}", (Object)((System.currentTimeMillis() - now) / 1000L));
        return null;
    }

    @Override
    protected void finishTask() {
        long now = System.currentTimeMillis();
        if (this.errMsg_ != null) {
            this.errMsg_ = this.errMsg_.replaceAll("\\s+$", "");
            if (!this.errMsg_.endsWith(".")) {
                this.errMsg_ = this.errMsg_ + ".";
            }
            LOGGER.error("Displaying error message: {}", (Object)this.errMsg_);
            SlowMessage.show(null, "Plot Error", this.errMsg_);
            return;
        }
        PanPlotFrame pframe = null;
        try {
            pframe = new PanPlotFrame(this.pmeta_);
            pframe.reveal();
        }
        catch (Exception exc) {
            Object errMsg;
            int colon;
            LOGGER.warn("There was an exception constructing the plot window: {}", (Object)exc.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((colon = ((String)(errMsg = exc.toString())).indexOf(58)) >= 0) {
                String first = ((String)errMsg).substring(0, colon).replaceFirst(".*\\.", "");
                String second = ((String)errMsg).substring(colon);
                errMsg = first + second;
            }
            SlowMessage.show(null, "Plot Error", new StringBuilder("There was an exception creating the plot window: ").append((String)errMsg));
        }
        catch (OutOfMemoryError err) {
            LOGGER.error("OutOfMemoryError reported when creating the plot frame");
            String errMsg = "An out of memory error occurred while creating the plot frame. Errors may recur. You should quit and restart Panoply.";
            if (pframe != null) {
                pframe.setVisible(false);
            }
            SlowMessage.show(null, "Plot Error", "An out of memory error occurred while creating the plot frame. Errors may recur. You should quit and restart Panoply.");
        }
        catch (Error err) {
            LOGGER.error("{} reported when creating the plot frame", (Object)err.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                err.printStackTrace();
            }
            String errMsg = err.getClass().getSimpleName() + " occurred while creating the plot frame. Errors may recur. You should quit and restart Panoply.";
            if (pframe != null) {
                pframe.setVisible(false);
            }
            SlowMessage.show(null, "Plot Error", errMsg);
        }
        LOGGER.trace("finish secs {}", (Object)((System.currentTimeMillis() - now) / 1000L));
    }
}

