/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanContourStyle implements DescribedItem
{
    NONE("None"),
    SOLID("Solid"),
    DOTS("Dotted"),
    DOTNEG("Dotted Negative"),
    DOTMINOR("Dotted Minor");

    private final String description_;

    private PanContourStyle(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanContourStyle matching(String str) {
        for (PanContourStyle item : PanContourStyle.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

