/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanPlotHeightFactor implements DescribedItem
{
    HEIGHT_025(25, "Height 25%", "height-025"),
    HEIGHT_050(50, "Height 50%", "height-050"),
    HEIGHT_075(75, "Height 75%", "height-075"),
    HEIGHT_100(100, "Height 100%", "height-100"),
    HEIGHT_150(150, "Height 150%", "height-150"),
    HEIGHT_200(200, "Height 200%", "height-200");

    private int ratio_;
    private String description_;
    private String actionID_;

    private PanPlotHeightFactor(int ratio, String description, String actionID) {
        this.ratio_ = ratio;
        this.description_ = description;
        this.actionID_ = actionID;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public int getHeightFactor() {
        return this.ratio_;
    }

    public String getActionID() {
        return this.actionID_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text) || this.actionID_ != null && this.actionID_.equalsIgnoreCase(text);
    }

    public static PanPlotHeightFactor matching(String str) {
        for (PanPlotHeightFactor item : PanPlotHeightFactor.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    public static PanPlotHeightFactor matching(int hfactor) {
        for (PanPlotHeightFactor item : PanPlotHeightFactor.values()) {
            if (item.getHeightFactor() != hfactor) continue;
            return item;
        }
        return null;
    }
}

