/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeFormatter;
import java.text.DecimalFormat;
import java.util.Objects;

public class AbsoluteTime
implements TimeFormatter {
    private final TimeUnit incrementField_;
    private final String incrementStr_;
    private final DecimalFormat nf_;
    private TimeUnit biggestField_;
    private TimeUnit smallestField_;
    private boolean hasFraction_;

    public AbsoluteTime(String units) {
        Objects.requireNonNull(units, "Units cannot be null");
        if (units.isEmpty()) {
            throw new IllegalArgumentException("Units string has no units!");
        }
        int asIndex = units.indexOf(" as ");
        if (asIndex < 1) {
            throw new IllegalArgumentException("Not absolute time units.");
        }
        this.incrementStr_ = units.substring(0, asIndex).toLowerCase();
        String formatString = units.substring(asIndex + 4);
        switch (this.incrementStr_) {
            case "year": 
            case "years": 
            case "calendar_year": {
                this.incrementField_ = TimeUnit.YEAR;
                break;
            }
            case "month": 
            case "months": 
            case "calendar_month": {
                this.incrementField_ = TimeUnit.MONTH;
                break;
            }
            case "day": 
            case "days": {
                this.incrementField_ = TimeUnit.DAY;
                break;
            }
            case "hour": 
            case "hours": {
                this.incrementField_ = TimeUnit.HOUR;
                break;
            }
            case "minute": 
            case "minutes": {
                this.incrementField_ = TimeUnit.MINUTE;
                break;
            }
            case "sec": 
            case "second": 
            case "seconds": {
                this.incrementField_ = TimeUnit.SECOND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized time increment '" + units + "'");
            }
        }
        if (formatString.contains("%f")) {
            this.hasFraction_ = true;
        }
        if (formatString.contains("%Y")) {
            this.biggestField_ = TimeUnit.YEAR;
        } else if (formatString.contains("%m")) {
            this.biggestField_ = TimeUnit.MONTH;
        } else if (formatString.contains("%d")) {
            this.biggestField_ = TimeUnit.DAY;
        } else if (formatString.contains("%H")) {
            this.biggestField_ = TimeUnit.HOUR;
        } else if (formatString.contains("%M")) {
            this.biggestField_ = TimeUnit.MINUTE;
        } else if (formatString.contains("%S")) {
            this.biggestField_ = TimeUnit.SECOND;
        } else if (this.hasFraction_) {
            this.biggestField_ = this.incrementField_;
        } else {
            throw new IllegalArgumentException("Unrecognized absolute time format '" + formatString + "'");
        }
        if (formatString.contains("%S")) {
            this.smallestField_ = TimeUnit.SECOND;
        } else if (formatString.contains("%M")) {
            this.smallestField_ = TimeUnit.MINUTE;
        } else if (formatString.contains("%H")) {
            this.smallestField_ = TimeUnit.HOUR;
        } else if (formatString.contains("%d")) {
            this.smallestField_ = TimeUnit.DAY;
        } else if (formatString.contains("%m")) {
            this.smallestField_ = TimeUnit.MONTH;
        } else if (formatString.contains("%Y")) {
            this.smallestField_ = TimeUnit.YEAR;
        } else if (this.hasFraction_) {
            this.smallestField_ = this.incrementField_;
        } else {
            throw new IllegalArgumentException("Unrecognized absolute time format '" + formatString + "'");
        }
        this.nf_ = new DecimalFormat();
    }

    public String getIncrementString() {
        return this.incrementStr_;
    }

    @Override
    public String format(Number timeval) {
        return this.format((Double)timeval);
    }

    @Override
    public String format(long timeval) {
        return this.format((double)timeval);
    }

    @Override
    public String format(double timeval) {
        StringBuilder sb = new StringBuilder();
        double thisOne = 0.0;
        double ttimeval = timeval;
        switch (this.incrementField_) {
            case SECOND: {
                thisOne = ttimeval % 100.0;
                ttimeval = (int)(ttimeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.SECOND) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_.compareTo(TimeUnit.SECOND) > 0) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_.compareTo(TimeUnit.SECOND) <= 0) break;
                sb.insert(0, ":");
            }
            case MINUTE: {
                thisOne = ttimeval % 100.0;
                ttimeval = (int)(ttimeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.MINUTE) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_.compareTo(TimeUnit.MINUTE) > 0) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_.compareTo(TimeUnit.MINUTE) <= 0) break;
                sb.insert(0, ":");
            }
            case HOUR: {
                thisOne = ttimeval % 100.0;
                ttimeval = (int)(ttimeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.HOUR) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_.compareTo(TimeUnit.HOUR) > 0) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_.compareTo(TimeUnit.HOUR) <= 0) break;
                sb.insert(0, " ");
            }
            case DAY: {
                thisOne = ttimeval % 100.0;
                ttimeval = (int)(ttimeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.DAY) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_.compareTo(TimeUnit.DAY) > 0) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_.compareTo(TimeUnit.DAY) <= 0) break;
                sb.insert(0, "-");
            }
            case MONTH: {
                thisOne = ttimeval % 100.0;
                ttimeval = (int)(ttimeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.MONTH) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_.compareTo(TimeUnit.MONTH) > 0) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_.compareTo(TimeUnit.MONTH) <= 0) break;
                sb.insert(0, "-");
            }
            case YEAR: {
                if (this.hasFraction_ && this.smallestField_ == TimeUnit.YEAR) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                this.nf_.setMinimumIntegerDigits(1);
                this.nf_.setMaximumIntegerDigits(12);
                this.nf_.setGroupingSize(12);
                sb.insert(0, this.nf_.format(ttimeval));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized time increment '" + this.incrementField_ + "'");
            }
        }
        return sb.toString();
    }

    static enum TimeUnit {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        MONTH,
        YEAR;

    }
}

