/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.color.ColorComboPopup;
import gov.nasa.giss.ui.color.ColorComboPopupListener;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ColorComboBox
extends JToggleButton
implements ColorComboPopupListener {
    private static final int PREF_WIDTH = 40;
    private static final int PREF_HEIGHT = 16;
    private ColorComboPopup popup_;
    private boolean shouldHandlePopupWillBecomeInvisible_;
    private boolean firingActionEvent_;
    protected FalseButton falseButton_;

    public ColorComboBox() {
        this(PaletteType.RAINBOW);
    }

    public ColorComboBox(PaletteType ptype) {
        super("Color");
        this.setOpaque(false);
        this.falseButton_ = new FalseButton();
        this.popup_ = new ColorComboPopup(this, ptype);
        this.addMouseListener(this.createButtonListener());
        this.popup_.addPopupMenuListener(this.createPopupListener());
        this.putClientProperty("doNotCancelPopup", new JComboBox().getClientProperty("doNotCancelPopup"));
        this.addAncestorListener(new WindowFocusAttacher());
        this.addKeyListener(new KeyResponder());
        this.addFocusListener(new FocusAdapter());
        if (PlatformUtils.isMacintosh()) {
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String pname = e.getPropertyName();
                    if (pname.equals("JComponent.sizeVariant")) {
                        ColorComboBox.this.falseButton_.putClientProperty(pname, e.getNewValue());
                    }
                }
            });
        }
    }

    public final JComboBox<Color> getFalseButton() {
        return this.falseButton_;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.falseButton_ != null) {
            this.falseButton_.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public int getItemCount() {
        return this.popup_.getItemCount();
    }

    public int getSelectedIndex() {
        return this.popup_.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.popup_.setSelectedIndex(index);
        this.repaint();
    }

    public Color getSelectedColor() {
        return this.popup_.getSelectedColor();
    }

    public void setSelectedColor(Color c) {
        this.popup_.setSelectedColor(c);
        this.updateFalseButton();
    }

    private void updateFalseButton() {
        Color c = this.popup_.getSelectedColor();
        this.falseButton_.removeAllItems();
        this.falseButton_.addItem(c);
        this.repaint();
    }

    private void hidePopupMenu() {
        if (this.popup_.isVisible()) {
            this.shouldHandlePopupWillBecomeInvisible_ = false;
            this.popup_.setVisible(false);
            this.setSelected(false);
            this.shouldHandlePopupWillBecomeInvisible_ = true;
        }
    }

    private void showPopupMenu(Point p) {
        Point pp = this.popup_.getSelectedPoint();
        Insets pi = this.popup_.getInsets();
        if (p == null || pp == null) {
            this.popup_.show(this, -12, -12);
        } else if (p == null) {
            this.popup_.show(this, this.getSize().width / 2 - pp.x - pi.left, this.getSize().height / 2 - pp.y - pi.top);
        } else {
            this.popup_.show(this, p.x - pp.x - pi.left, p.y - pp.y - pi.top);
        }
    }

    private MouseListener createButtonListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ColorComboBox.this.popup_.isShowing()) {
                    ColorComboBox.this.hidePopupMenu();
                } else if (ColorComboBox.this.isEnabled()) {
                    ColorComboBox.this.showPopupMenu(e.getPoint());
                }
            }
        };
    }

    private PopupMenuListener createPopupListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (ColorComboBox.this.shouldHandlePopupWillBecomeInvisible_) {
                    ColorComboBox.this.setSelected(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ColorComboBox.this.setSelected(false);
            }
        };
    }

    @Override
    public void colorChanged(int oldIndex, Color oldValue, int newIndex, Color newValue) {
        this.updateFalseButton();
        ItemEvent e1 = new ItemEvent(this, oldIndex, oldValue, 2);
        ItemEvent e2 = new ItemEvent(this, newIndex, newValue, 1);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e1);
            ((ItemListener)listeners[i + 1]).itemStateChanged(e2);
        }
        if (!this.firingActionEvent_) {
            this.firingActionEvent_ = true;
            ActionEvent e = new ActionEvent(this, 1001, "comboBoxChanged", EventQueue.getMostRecentEventTime(), 0);
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            this.firingActionEvent_ = false;
        }
    }

    @Override
    public void setAction(Action a) {
        this.addActionListener(a);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.falseButton_.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        this.falseButton_.paint(g);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.falseButton_.setSize(this.getSize());
        this.falseButton_.doLayout();
    }

    class KeyResponder
    extends KeyAdapter {
        KeyResponder() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int kcode = e.getKeyCode();
            if (e.isMetaDown() || e.isControlDown() || e.isAltDown() || kcode == 16 || kcode == 20 || kcode == 127 || kcode >= 112 && kcode <= 123) {
                return;
            }
            if (ColorComboBox.this.popup_.isVisible()) {
                if (kcode == 27) {
                    ColorComboBox.this.hidePopupMenu();
                } else if (kcode == 10 || kcode == 32) {
                    ColorComboBox.this.popup_.shiftBin(kcode);
                } else if (kcode == 40 || kcode == 38 || kcode == 37 || kcode == 39) {
                    ColorComboBox.this.popup_.shiftBin(kcode);
                }
            } else {
                ColorComboBox.this.showPopupMenu(null);
            }
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    class WindowFocusAdapter
    extends WindowAdapter {
        WindowFocusAdapter() {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            ColorComboBox.this.hidePopupMenu();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            ColorComboBox.this.hidePopupMenu();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            ColorComboBox.this.hidePopupMenu();
        }
    }

    class WindowFocusAttacher
    implements AncestorListener {
        WindowFocusAttacher() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            JFrame jf = GuiUtils.getParentFrame(ColorComboBox.this);
            if (jf != null) {
                jf.addWindowListener(new WindowFocusAdapter());
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
        }
    }

    class FocusAdapter
    implements FocusListener {
        FocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ColorComboBox.this.hidePopupMenu();
        }
    }

    class FalseButtonCellRenderer
    extends JComponent
    implements ListCellRenderer<Color> {
        private boolean isSelected_;
        private boolean hasFocus_;

        FalseButtonCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(40 + ins.left + ins.right, 16 + ins.top + ins.bottom);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
            Color fgcolor = this.getForeground();
            Color bgcolor = this.getBackground();
            Color c = ColorComboBox.this.getSelectedColor();
            Dimension size = this.getSize();
            if (this.isSelected_) {
                g2d.setColor(bgcolor);
                g2d.fillRect(0, 0, size.width, size.height);
            }
            Insets ins = this.getInsets();
            int boxSize = this.getFont().getSize() - 2;
            int boxTop = (size.height - boxSize) / 2;
            if (this.isEnabled()) {
                g2d.setColor(fgcolor);
            } else {
                g2d.setColor(new Color(fgcolor.getRed(), fgcolor.getGreen(), fgcolor.getBlue(), 51));
            }
            g2d.fillRect(ins.left, boxTop, 40, boxSize);
            g2d.setColor(c);
            g2d.fillRect(ins.left + 1, boxTop + 1, 38, boxSize - 2);
            g2d.dispose();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Color> list, Color value, int index, boolean isSelected, boolean cellHasFocus) {
            this.isSelected_ = isSelected;
            this.hasFocus_ = cellHasFocus;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class FalseButton
    extends JComboBox<Color> {
        public FalseButton() {
            this.setRenderer(new FalseButtonCellRenderer());
            this.addItem(Color.WHITE);
            this.setDoubleBuffered(false);
            this.setOpaque(false);
        }

        @Override
        public boolean isFocusOwner() {
            if (ColorComboBox.this.popup_ == null) {
                return false;
            }
            return ColorComboBox.this.isFocusOwner() || ColorComboBox.this.popup_.isShowing();
        }

        @Override
        public boolean hasFocus() {
            return this.isFocusOwner();
        }
    }
}

