/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.label;

import gov.nasa.giss.ui.label.LabelSizeVariantListener;
import gov.nasa.giss.ui.plaf.MultiLineLabelUI;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class MultiLineLabel
extends JComponent {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    private int hAlignment_ = 2;
    private int vAlignment_ = 1;
    private String text_;

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String text) {
        this(text, 2);
    }

    public MultiLineLabel(String text, int halign) {
        this.finishInit(text, halign);
    }

    public MultiLineLabel(String text, int breakAt, int halign) {
        String message1 = text.replaceAll("\n", " ").replaceAll("  *", " ");
        String[] words = message1.split("\\s+");
        StringBuilder sb = new StringBuilder("");
        int currentLineLength = 0;
        for (String word : words) {
            if (currentLineLength > breakAt || currentLineLength + word.length() > breakAt + 10) {
                sb.append('\n');
                currentLineLength = 0;
            }
            sb.append(word).append(' ');
            currentLineLength += word.length() + 1;
        }
        this.finishInit(sb.toString(), halign);
    }

    private void finishInit(String text, int halign) {
        this.setText(text);
        this.setHorizontalAlignment(halign);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            this.setFont(f);
        }
        this.setUI(new MultiLineLabelUI());
        if (PlatformUtils.isMacintosh()) {
            this.addPropertyChangeListener(new LabelSizeVariantListener(this));
        }
    }

    public void setUI(MultiLineLabelUI ui) {
        super.setUI(ui);
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String s) {
        this.text_ = s;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.hAlignment_;
    }

    public void setHorizontalAlignment(int ha) {
        this.hAlignment_ = ha;
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.vAlignment_;
    }

    public void setVerticalAlignment(int va) {
        this.vAlignment_ = va;
        this.repaint();
    }
}

