/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.windoid.WindoidHeaderMouseListener;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindoidHeader
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int HDR_HEIGHT = 22;
    private static final int BTN_SIZE = 10;
    private static final int BTN_GAP = 4;
    private static final int LEFT_MARGIN = 8;
    private static final int TOP_MARGIN = 6;
    private static final Color CLOSE_COLOR = new Color(247, 70, 69);
    private static final Color MINIM_COLOR = new Color(251, 175, 21);
    private static final Color RESIZE_COLOR = new Color(57, 198, 41);
    private static final Color LIGHT_TEXT_COLOR = new Color(51, 51, 51);
    private static final Color LIGHT_BKGD_TOP = new Color(193, 194, 194);
    private static final Color LIGHT_BKGD_BOTTOM = new Color(165, 166, 166);
    private static final Color LIGHT_BKGD_UNFOCUS = new Color(165, 166, 166);
    private static final Color LIGHT_INACTIVE_COLOR = new Color(199, 199, 199);
    private static final Color LIGHT_BORDER_COLOR = new Color(124, 125, 125);
    private static final Color DARK_TEXT_COLOR = new Color(255, 255, 255);
    private static final Color DARK_BKGD_TOP = new Color(87, 87, 87);
    private static final Color DARK_BKGD_BOTTOM = new Color(84, 84, 84);
    private static final Color DARK_BKGD_UNFOCUS = new Color(41, 41, 41);
    private static final Color DARK_INACTIVE_COLOR = new Color(76, 75, 72);
    private static final Color DARK_BORDER_COLOR = new Color(101, 102, 103);
    private static final Stroke BORDER_STROKE = new BasicStroke(1.0f, 2, 0);
    private boolean dark_;
    private Color backgroundTop_;
    private Color backgroundBottom_;
    private Color textColor_;
    private Color inactiveColor_;
    private Color borderColor_;
    private Color unfocusColor_;
    private final String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean measured_;
    private final int closeLeft_;
    private final int hideLeft_;
    private final int resizeLeft_;
    private final int titleLeft_;
    private boolean inFocused_;
    private boolean closeable_;
    private boolean hideable_;
    private boolean resizeable_;
    private boolean closeHighlighted_;
    private boolean hideHighlighted_;
    private boolean resizeHighlighted_;
    private boolean resizeVisible_;
    private int minWidth_;

    public WindoidHeader(String title, boolean closeable) {
        this.title_ = title;
        this.closeable_ = closeable;
        this.closeLeft_ = 8;
        this.hideLeft_ = this.closeLeft_ + 10 + 4;
        this.resizeLeft_ = this.hideLeft_ + 10 + 4;
        this.titleLeft_ = this.resizeLeft_ + 10 + 8;
        if (PlatformUtils.isMacintosh()) {
            this.minWidth_ = 54;
            this.resizeVisible_ = true;
        } else {
            this.minWidth_ = 40;
            this.resizeVisible_ = false;
        }
        this.setColorThemeDark(true);
        this.setBorder(null);
        this.setLayout(null);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            f = f.deriveFont(13.25f);
            this.setFont(f);
        }
    }

    public String getTitle() {
        return this.title_;
    }

    public boolean isColorThemeDark() {
        return this.dark_;
    }

    public final void setColorThemeDark(boolean dark) {
        this.dark_ = dark;
        if (dark) {
            this.textColor_ = DARK_TEXT_COLOR;
            this.backgroundTop_ = DARK_BKGD_TOP;
            this.backgroundBottom_ = DARK_BKGD_BOTTOM;
            this.inactiveColor_ = DARK_INACTIVE_COLOR;
            this.borderColor_ = DARK_BORDER_COLOR;
            this.unfocusColor_ = DARK_BKGD_UNFOCUS;
        } else {
            this.textColor_ = LIGHT_TEXT_COLOR;
            this.backgroundTop_ = LIGHT_BKGD_TOP;
            this.backgroundBottom_ = LIGHT_BKGD_BOTTOM;
            this.inactiveColor_ = LIGHT_INACTIVE_COLOR;
            this.borderColor_ = LIGHT_BORDER_COLOR;
            this.unfocusColor_ = LIGHT_BKGD_UNFOCUS;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        if (this.titleWidth_ > 0) {
            int tw = Math.max(50, this.titleWidth_) + 8;
            return new Dimension(this.minWidth_ + tw, 22);
        }
        return new Dimension(this.minWidth_, 22);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    public void addHeaderMouseListener(WindoidHeaderMouseListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void removeHeaderMouseListener(WindoidHeaderMouseListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
    }

    void setInFocusedWindow(boolean inFocused) {
        this.inFocused_ = inFocused;
    }

    public boolean inCloseButton(Point p) {
        if (!this.closeable_) {
            return false;
        }
        return p.x >= this.closeLeft_ && p.x < this.closeLeft_ + 10;
    }

    public boolean inResizeButton(Point p) {
        if (!this.resizeVisible_ || !this.resizeable_) {
            return false;
        }
        return p.x >= this.resizeLeft_ && p.x < this.resizeLeft_ + 10;
    }

    public boolean inHideButton(Point p) {
        if (!this.hideable_) {
            return false;
        }
        return p.x >= this.hideLeft_ && p.x < this.hideLeft_ + 10;
    }

    public boolean isCloseable() {
        return this.closeable_;
    }

    public void setCloseable(boolean closeable) {
        this.closeable_ = closeable;
    }

    public boolean isResizeable() {
        return this.resizeable_;
    }

    public void setResizeable(boolean resizeable) {
        this.resizeable_ = resizeable;
    }

    public void setCloseHighlighted(boolean highlighted) {
        this.closeHighlighted_ = highlighted;
    }

    public void setResizeHighlighted(boolean highlighted) {
        this.resizeHighlighted_ = highlighted;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtils.antialias(g2d);
        boolean t = false;
        int b = 22;
        if (this.inFocused_) {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.backgroundTop_, 0.0f, 22.0f, this.backgroundBottom_);
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, w, 22);
        } else {
            g2d.setColor(this.unfocusColor_);
            g2d.fillRect(0, 0, w, 22);
        }
        g2d.setColor(this.borderColor_);
        g2d.setStroke(BORDER_STROKE);
        Line2D.Double line = new Line2D.Double(0.0, 0.0, w, 0.0);
        g2d.draw(line);
        line = new Line2D.Double(0.0, 21.5, w, 21.5);
        g2d.draw(line);
        if (this.closeHighlighted_) {
            this.drawButton(g2d, this.closeLeft_, CLOSE_COLOR);
        } else if (this.closeable_) {
            this.drawButton(g2d, this.closeLeft_, CLOSE_COLOR);
        } else {
            this.drawButton(g2d, this.closeLeft_, this.inactiveColor_);
        }
        if (this.hideHighlighted_) {
            this.drawButton(g2d, this.hideLeft_, MINIM_COLOR);
        } else if (this.hideable_) {
            this.drawButton(g2d, this.hideLeft_, MINIM_COLOR);
        } else {
            this.drawButton(g2d, this.hideLeft_, this.inactiveColor_);
        }
        if (this.resizeVisible_) {
            if (this.resizeHighlighted_) {
                this.drawButton(g2d, this.resizeLeft_, RESIZE_COLOR);
            } else if (this.resizeable_) {
                this.drawButton(g2d, this.resizeLeft_, RESIZE_COLOR);
            } else {
                this.drawButton(g2d, this.resizeLeft_, this.inactiveColor_);
            }
        }
        if (this.titleWidth_ > 0) {
            g2d.setColor(this.textColor_);
            int x = this.titleLeft_;
            int y = (22 - this.lineHeight_) / 2 + this.lineAscent_;
            g2d.drawString(this.title_, x, y);
        }
        g2d.dispose();
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
        this.measured_ = true;
    }

    private void drawButton(Graphics2D g2d, int left, Color c) {
        Ellipse2D.Float button = new Ellipse2D.Float(left, 6.0f, 10.0f, 10.0f);
        g2d.setColor(c);
        g2d.fill(button);
    }
}

