import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.shapes import FM90

fig, ax = plt.subplots()

# generate the curves and plot them
x = np.arange(3.8,8.6,0.1)/u.micron

ext_model = FM90()
ax.plot(x,ext_model(x),label='total')

ext_model = FM90(C3=0.0, C4=0.0)
ax.plot(x,ext_model(x),label='linear term')

ext_model = FM90(C1=0.0, C2=0.0, C4=0.0)
ax.plot(x,ext_model(x),label='bump term')

ext_model = FM90(C1=0.0, C2=0.0, C3=0.0)
ax.plot(x,ext_model(x),label='FUV rise term')

ax.set_xlabel(r'$x$ [$\mu m^{-1}$]')
ax.set_ylabel(r'$E(\lambda - V)/E(B - V)$')

# for 2nd x-axis with lambda values
axis_xs = np.array([0.12, 0.15, 0.2, 0.3])
new_ticks = 1 / axis_xs
new_ticks_labels = ["%.2f" % z for z in axis_xs]
tax = ax.twiny()
tax.set_xlim(ax.get_xlim())
tax.set_xticks(new_ticks)
tax.set_xticklabels(new_ticks_labels)
tax.set_xlabel(r"$\lambda$ [$\mu$m]")

ax.legend(loc='best')
plt.show()