import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.averages import G21_MWAvg

fig, ax = plt.subplots()

# generate the curves and plot them
lam = np.logspace(np.log10(1.01), np.log10(31.9), num=1000)
x = (1.0/lam)/u.micron

# define the extinction model
ext_model = G21_MWAvg()

ax.plot(1.0/x,ext_model(x),label='G21_MWAvg')
ax.errorbar(1.0/ext_model.obsdata_x_irs, ext_model.obsdata_axav_irs,
            yerr=ext_model.obsdata_axav_unc_irs,
            fmt='ko', label='obsdata (IRS)')
ax.errorbar(1.0/ext_model.obsdata_x_bands, ext_model.obsdata_axav_bands,
            yerr=ext_model.obsdata_axav_unc_bands,
            fmt='g^', label='obsdata (photometry)')

ax.set_xlabel(r'$\lambda$ [$\mu m$]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.set_xscale('log')
ax.set_yscale('log')

ax.legend(loc='best')
plt.show()