import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import ScalarFormatter
import astropy.units as u

from dust_extinction.parameter_averages import G16

fig, ax = plt.subplots()

# temp model to get the correct x range
text_model = G16()

# generate the curves and plot them
x = np.arange(text_model.x_range[0], text_model.x_range[1],0.1)/u.micron

fAs = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
for cur_fA in fAs:
   ext_model = G16(RvA=3.1, fA=cur_fA)
   ax.plot(1./x,ext_model(x),label=r'$f_A = ' + str(cur_fA) + '$')

ax.set_xscale('log')
ax.xaxis.set_major_formatter(ScalarFormatter())

ax.set_xlabel(r'$\lambda$ [$\mu$m]')
ax.set_ylabel(r'$A(\lambda)/A(V)$')

ax.set_title('G16; $f_A$ variable; $R(V)_A = 3.1$')

ax.legend(loc='best', title=r'$R_A(V) = 3.1$')
plt.tight_layout()
plt.show()