# This code is part of Qiskit.
#
# (C) Copyright IBM 2019, 2023.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.


"""
Mocked versions of real quantum backends.
"""

# BackendV2 Backends
from .algiers import FakeAlgiers
from .almaden import FakeAlmadenV2
from .armonk import FakeArmonkV2
from .athens import FakeAthensV2
from .auckland import FakeAuckland
from .belem import FakeBelemV2
from .boeblingen import FakeBoeblingenV2
from .bogota import FakeBogotaV2
from .brisbane import FakeBrisbane
from .brooklyn import FakeBrooklynV2
from .burlington import FakeBurlingtonV2
from .cairo import FakeCairoV2
from .cambridge import FakeCambridgeV2
from .casablanca import FakeCasablancaV2
from .cusco import FakeCusco
from .essex import FakeEssexV2
from .fez import FakeFez
from .fractional import FakeFractionalBackend
from .geneva import FakeGeneva
from .guadalupe import FakeGuadalupeV2
from .hanoi import FakeHanoiV2
from .jakarta import FakeJakartaV2
from .johannesburg import FakeJohannesburgV2
from .kawasaki import FakeKawasaki
from .kolkata import FakeKolkataV2
from .kyiv import FakeKyiv
from .kyoto import FakeKyoto
from .lagos import FakeLagosV2
from .lima import FakeLimaV2
from .london import FakeLondonV2
from .manhattan import FakeManhattanV2
from .manila import FakeManilaV2
from .marrakesh import FakeMarrakesh
from .melbourne import FakeMelbourneV2
from .montreal import FakeMontrealV2
from .mumbai import FakeMumbaiV2
from .nairobi import FakeNairobiV2
from .osaka import FakeOsaka
from .oslo import FakeOslo
from .ourense import FakeOurenseV2
from .paris import FakeParisV2
from .peekskill import FakePeekskill
from .perth import FakePerth
from .prague import FakePrague
from .poughkeepsie import FakePoughkeepsieV2
from .quebec import FakeQuebec
from .quito import FakeQuitoV2
from .rochester import FakeRochesterV2
from .rome import FakeRomeV2
from .santiago import FakeSantiagoV2
from .sherbrooke import FakeSherbrooke
from .singapore import FakeSingaporeV2
from .sydney import FakeSydneyV2
from .torino import FakeTorino
from .toronto import FakeTorontoV2
from .valencia import FakeValenciaV2
from .vigo import FakeVigoV2
from .washington import FakeWashingtonV2
from .yorktown import FakeYorktownV2
