# This code is part of Qiskit.
#
# (C) Copyright IBM 2021.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""Internal utilities."""

from .converters import (
    utc_to_local,
    local_to_utc,
    seconds_to_duration,
    duration_difference,
)
from .embeddings import Embedding
from .utils import (
    to_python_identifier,
    is_crn,
    default_runtime_url_resolver,
    resolve_crn,
    are_circuits_dynamic,
    cname_from_crn,
    get_iam_api_url,
    get_global_search_api_url,
    get_global_catalog_api_url,
)
from .validations import (
    validate_estimator_pubs,
    validate_classical_registers,
    validate_no_dd_with_dynamic_circuits,
    validate_isa_circuits,
    validate_job_tags,
    validate_rzz_pubs,
)

from .json import RuntimeEncoder, RuntimeDecoder, to_base64_string
