Sampling units: Monetary Units
===

Sampling from the population requires knowledge of the sampling units; physical representations of the population that need to be audited. Sampling units can be individual <i>transactions</i> or <i>monetary units</i>. For statistical sampling, sampling probabilities are assignned to the sampling units of the population elements. The total collection of all sampling units with an assigned selection probability is named the sampling frame. 

-------

Monetary unit sampling (MUS)
==========================

### Procedure

The sampling frame for monetary unit sampling (MUS) is the total collection of individual monetary units in the population. A sampling unit for MUS is an individual monetary unit within all possible monetary units, like 1$ in a balance of $1000. In the dollar case, the population entry that includes the sampled dollar is selected. For example, if the 10th dollar for a receipt of coffee milk is selected the coffee receipt is audited and its audit (true) value is determined for evaluation. 

### Implications for selection

The implication of a MUS sampling scheme is that transactions are selected with a probability proportional to their value, since larger transactions contain more individual sampling units. It is therefore the preferred selection type for financial populations and is followed up with a Stringer bound as evaluation mechanism in JfA.

### Pitfalls

Be aware that transactions with a book value of $0 also have 0 sampling units. It is therefore recommended that when the population contains transactions that are booked at $0, record sampling is used to sample from the population.