/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.select;

import com.tobiasdiez.easybind.select.NestedSelectionElement;
import com.tobiasdiez.easybind.select.NestedSelectionElementFactory;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;

class IntermediateSelectionElement<T, U, V>
implements NestedSelectionElement<T, V> {
    private final Function<? super T, ObservableValue<U>> selector;
    private final NestedSelectionElement<U, V> nested;
    private final Runnable onInvalidation;
    private final InvalidationListener observableInvalidationListener = obs -> this.observableInvalidated();
    private ObservableValue<U> observable = null;

    public IntermediateSelectionElement(Runnable onInvalidation, Function<? super T, ObservableValue<U>> selector, NestedSelectionElementFactory<U, V> nestedSelectionFactory) {
        this.onInvalidation = onInvalidation;
        this.selector = selector;
        this.nested = nestedSelectionFactory.create(this::nestedInvalidated);
    }

    @Override
    public void connect(T baseVal) {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        this.observable = this.selector.apply(baseVal);
        this.observable.addListener(this.observableInvalidationListener);
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            this.nested.disconnect();
            this.observable.removeListener(this.observableInvalidationListener);
            this.observable = null;
        }
    }

    @Override
    public final boolean isConnected() {
        return this.observable != null;
    }

    @Override
    public V getValue() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (!this.nested.isConnected()) {
            Object observableVal = this.observable.getValue();
            if (observableVal == null) {
                return null;
            }
            this.nested.connect(observableVal);
        }
        return this.nested.getValue();
    }

    private void nestedInvalidated() {
        this.onInvalidation.run();
    }

    private void observableInvalidated() {
        this.nested.disconnect();
        this.onInvalidation.run();
    }
}

