/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.backup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import org.controlsfx.control.HyperlinkLabel;
import org.jabref.gui.FXDialog;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BackupFileType;
import org.jabref.logic.util.io.BackupFileUtil;
import org.jabref.preferences.ExternalApplicationsPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupResolverDialog
extends FXDialog {
    public static final ButtonType RESTORE_FROM_BACKUP = new ButtonType(Localization.lang("Restore from backup", new Object[0]), ButtonBar.ButtonData.OK_DONE);
    public static final ButtonType REVIEW_BACKUP = new ButtonType(Localization.lang("Review backup", new Object[0]), ButtonBar.ButtonData.LEFT);
    public static final ButtonType IGNORE_BACKUP = new ButtonType(Localization.lang("Ignore backup", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupResolverDialog.class);

    public BackupResolverDialog(Path originalPath, Path backupDir, ExternalApplicationsPreferences externalApplicationsPreferences) {
        super(Alert.AlertType.CONFIRMATION, Localization.lang("Backup found", new Object[0]), true);
        this.setHeaderText(null);
        this.getDialogPane().setMinHeight(180.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{RESTORE_FROM_BACKUP, REVIEW_BACKUP, IGNORE_BACKUP});
        Optional<Path> backupPathOpt = BackupFileUtil.getPathOfLatestExistingBackupFile(originalPath, BackupFileType.BACKUP, backupDir);
        String backupFilename = backupPathOpt.map(Path::getFileName).map(Path::toString).orElse(Localization.lang("File not found", new Object[0]));
        String content = Localization.lang("A backup file for '%0' was found at [%1]", originalPath.getFileName().toString(), backupFilename) + "\n" + Localization.lang("This could indicate that JabRef did not shut down cleanly last time the file was used.", new Object[0]) + "\n\n" + Localization.lang("Do you want to recover the library from the backup file?", new Object[0]);
        this.setContentText(content);
        HyperlinkLabel contentLabel = new HyperlinkLabel(content);
        contentLabel.setPrefWidth(360.0);
        contentLabel.setOnAction(e -> {
            if (backupPathOpt.isPresent()) {
                if (!(e.getSource() instanceof Hyperlink)) {
                    return;
                }
                String clickedLinkText = ((Hyperlink)e.getSource()).getText();
                if (backupFilename.equals(clickedLinkText)) {
                    try {
                        JabRefDesktop.openFolderAndSelectFile((Path)backupPathOpt.get(), externalApplicationsPreferences, null);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Could not open backup folder", (Throwable)ex);
                    }
                }
            }
        });
        this.getDialogPane().setContent((Node)contentLabel);
    }
}

