/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.bibtexextractor;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.bibtexextractor.BibtexExtractorViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class ExtractBibtexDialog
extends BaseDialog<Void> {
    private final Button buttonParse;
    @FXML
    private TextArea input;
    @FXML
    private ButtonType parseButtonType;
    private BibtexExtractorViewModel viewModel;
    @Inject
    private StateManager stateManager;
    @Inject
    private DialogService dialogService;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private UndoManager undoManager;
    @Inject
    private PreferencesService preferencesService;

    public ExtractBibtexDialog() {
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setTitle(Localization.lang("Plain References Parser", new Object[0]));
        this.input.setPromptText(Localization.lang("Please enter the plain references to extract from separated by double empty lines.", new Object[0]));
        this.input.selectAll();
        this.buttonParse = (Button)this.getDialogPane().lookupButton(this.parseButtonType);
        this.buttonParse.setTooltip(new Tooltip(Localization.lang("Starts the extraction and adds the resulting entries to the currently opened database", new Object[0])));
        this.buttonParse.setOnAction(event -> this.viewModel.startParsing());
        this.buttonParse.disableProperty().bind((ObservableValue)this.viewModel.inputTextProperty().isEmpty());
    }

    @FXML
    private void initialize() {
        BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        this.viewModel = new BibtexExtractorViewModel(database, this.dialogService, this.preferencesService, this.fileUpdateMonitor, this.taskExecutor, this.undoManager, this.stateManager);
        this.input.textProperty().bindBidirectional((Property)this.viewModel.inputTextProperty());
    }
}

