/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.entrychange;

import javax.swing.undo.CompoundEdit;
import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntries;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public final class EntryChange
extends DatabaseChange {
    private final BibEntry oldEntry;
    private final BibEntry newEntry;

    public EntryChange(BibEntry oldEntry, BibEntry newEntry, BibDatabaseContext databaseContext, DatabaseChangeResolverFactory databaseChangeResolverFactory) {
        super(databaseContext, databaseChangeResolverFactory);
        this.oldEntry = oldEntry;
        this.newEntry = newEntry;
        this.setChangeName(oldEntry.getCitationKey().map(key -> Localization.lang("Modified entry '%0'", key)).orElse(Localization.lang("Modified entry", new Object[0])));
    }

    public EntryChange(BibEntry oldEntry, BibEntry newEntry, BibDatabaseContext databaseContext) {
        this(oldEntry, newEntry, databaseContext, null);
    }

    public BibEntry getOldEntry() {
        return this.oldEntry;
    }

    public BibEntry getNewEntry() {
        return this.newEntry;
    }

    @Override
    public void applyChange(NamedCompound undoEdit) {
        this.databaseContext.getDatabase().removeEntry(this.oldEntry);
        this.databaseContext.getDatabase().insertEntry(this.newEntry);
        CompoundEdit changeEntryEdit = new CompoundEdit();
        changeEntryEdit.addEdit(new UndoableRemoveEntries(this.databaseContext.getDatabase(), this.oldEntry));
        changeEntryEdit.addEdit(new UndoableInsertEntries(this.databaseContext.getDatabase(), this.newEntry));
        changeEntryEdit.end();
        undoEdit.addEdit(changeEntryEdit);
    }
}

