/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.commonfxcontrols;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import org.jabref.gui.StateManager;
import org.jabref.gui.commonfxcontrols.FieldFormatterCleanupsPanelViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;

public class FieldFormatterCleanupsPanel
extends VBox {
    @FXML
    private CheckBox cleanupsEnabled;
    @FXML
    private TableView<FieldFormatterCleanup> cleanupsList;
    @FXML
    private TableColumn<FieldFormatterCleanup, Field> fieldColumn;
    @FXML
    private TableColumn<FieldFormatterCleanup, Formatter> formatterColumn;
    @FXML
    private TableColumn<FieldFormatterCleanup, Field> actionsColumn;
    @FXML
    private ComboBox<Field> addableFields;
    @FXML
    private ComboBox<Formatter> addableFormatters;
    @Inject
    private StateManager stateManager;
    private FieldFormatterCleanupsPanelViewModel viewModel;

    public FieldFormatterCleanupsPanel() {
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
    }

    @FXML
    private void initialize() {
        this.viewModel = new FieldFormatterCleanupsPanelViewModel(this.stateManager);
        this.setupTable();
        this.setupCombos();
        this.setupBindings();
    }

    private void setupTable() {
        this.cleanupsList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.fieldColumn.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper((Object)((FieldFormatterCleanup)cellData.getValue()).getField()));
        new ValueTableCellFactory().withText(Field::getDisplayName).install(this.fieldColumn);
        this.formatterColumn.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper((Object)((FieldFormatterCleanup)cellData.getValue()).getFormatter()));
        new ValueTableCellFactory().withText(Formatter::getName).install(this.formatterColumn);
        this.actionsColumn.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper((Object)((FieldFormatterCleanup)cellData.getValue()).getField()));
        new ValueTableCellFactory().withGraphic(field -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(field -> Localization.lang("Remove formatter for %0", field.getDisplayName())).withOnMouseClickedEvent(item -> event -> this.viewModel.removeCleanup((FieldFormatterCleanup)this.cleanupsList.getSelectionModel().getSelectedItem())).install(this.actionsColumn);
        this.viewModel.selectedCleanupProperty().setValue((Object)this.cleanupsList.getSelectionModel());
        this.cleanupsList.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.viewModel.removeCleanup((FieldFormatterCleanup)this.cleanupsList.getSelectionModel().getSelectedItem());
            }
        });
    }

    private void setupCombos() {
        new ViewModelListCellFactory().withText(Field::getDisplayName).install(this.addableFields);
        this.addableFields.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.addableFields.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.TAB || event.getCode() == KeyCode.ENTER) {
                this.addableFormatters.requestFocus();
                event.consume();
            }
        });
        new ViewModelListCellFactory().withText(Formatter::getName).withStringTooltip(Formatter::getDescription).install(this.addableFormatters);
        this.addableFormatters.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.viewModel.addCleanup();
                event.consume();
            }
        });
    }

    private void setupBindings() {
        BindingsHelper.bindBidirectional(this.cleanupsEnabled.selectedProperty(), this.viewModel.cleanupsDisableProperty(), disabled -> this.cleanupsEnabled.selectedProperty().setValue(Boolean.valueOf(disabled == false)), selected -> this.viewModel.cleanupsDisableProperty().setValue(Boolean.valueOf(selected == false)));
        this.cleanupsList.itemsProperty().bind(this.viewModel.cleanupsListProperty());
        this.addableFields.itemsProperty().bind(this.viewModel.availableFieldsProperty());
        this.addableFields.valueProperty().bindBidirectional(this.viewModel.selectedFieldProperty());
        this.addableFormatters.itemsProperty().bind(this.viewModel.availableFormattersProperty());
        this.addableFormatters.valueProperty().bindBidirectional(this.viewModel.selectedFormatterProperty());
    }

    @FXML
    private void resetToRecommended() {
        this.viewModel.resetToRecommended();
    }

    @FXML
    private void clearAll() {
        this.viewModel.clearAll();
    }

    @FXML
    private void addCleanup() {
        this.viewModel.addCleanup();
    }

    public BooleanProperty cleanupsDisableProperty() {
        return this.viewModel.cleanupsDisableProperty();
    }

    public ListProperty<FieldFormatterCleanup> cleanupsProperty() {
        return this.viewModel.cleanupsListProperty();
    }
}

