/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.preferences.FilePreferences;

@AllowedToUseAwt(value="Requires AWT to open a file")
public class OSX
extends NativeDesktop {
    @Override
    public void openFile(String filePath, String fileType, FilePreferences filePreferences) throws IOException {
        Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByExt(fileType, filePreferences);
        if (type.isPresent() && !type.get().getOpenWithApplication().isEmpty()) {
            this.openFileWithApplication(filePath, type.get().getOpenWithApplication());
        } else {
            String[] cmd = new String[]{"/usr/bin/open", filePath};
            Runtime.getRuntime().exec(cmd);
        }
    }

    @Override
    public void openFileWithApplication(String filePath, String application) throws IOException {
        String[] stringArray;
        if (application != null && !application.isEmpty()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "/usr/bin/open";
            stringArray2[1] = "-a";
            stringArray2[2] = application;
            stringArray = stringArray2;
            stringArray2[3] = filePath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "/usr/bin/open";
            stringArray = stringArray3;
            stringArray3[1] = filePath;
        }
        String[] cmd = stringArray;
        new ProcessBuilder(cmd).start();
    }

    @Override
    public void openFolderAndSelectFile(Path file) throws IOException {
        String[] cmd = new String[]{"/usr/bin/open", "-R", file.toString()};
        Runtime.getRuntime().exec(cmd);
    }

    @Override
    public void openConsole(String absolutePath, DialogService dialogService) throws IOException {
        new ProcessBuilder("open", "-a", "Terminal", absolutePath).start();
    }

    @Override
    public String detectProgramPath(String programName, String directoryName) {
        return programName;
    }

    @Override
    public Path getApplicationDirectory() {
        return Path.of("/Applications", new String[0]);
    }
}

