/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.duplicationFinder;

import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.BorderPane;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.mergeentries.newmergedialog.ThreeWayMergeView;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.DialogWindowState;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class DuplicateResolverDialog
extends BaseDialog<DuplicateResolverResult> {
    private final BibDatabaseContext database;
    private final StateManager stateManager;
    private ThreeWayMergeView threeWayMerge;
    private final DialogService dialogService;
    private final ActionFactory actionFactory;
    private final PreferencesService preferencesService;

    public DuplicateResolverDialog(BibEntry one, BibEntry two, DuplicateResolverType type, BibDatabaseContext database, StateManager stateManager, DialogService dialogService, PreferencesService preferencesService) {
        this.setTitle(Localization.lang("Possible duplicate entries", new Object[0]));
        this.database = database;
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.actionFactory = new ActionFactory();
        this.init(one, two, type);
    }

    private void init(BibEntry one, BibEntry two, DuplicateResolverType type) {
        DialogWindowState state;
        ButtonType both;
        ButtonType second;
        ButtonType first;
        ButtonType cancel = ButtonType.CANCEL;
        ButtonType merge = new ButtonType(Localization.lang("Keep merged", new Object[0]), ButtonBar.ButtonData.OK_DONE);
        ButtonType removeExact = new ButtonType(Localization.lang("Automatically remove exact duplicates", new Object[0]), ButtonBar.ButtonData.LEFT);
        boolean removeExactVisible = false;
        switch (type.ordinal()) {
            case 0: {
                first = new ButtonType(Localization.lang("Keep left", new Object[0]), ButtonBar.ButtonData.LEFT);
                second = new ButtonType(Localization.lang("Keep right", new Object[0]), ButtonBar.ButtonData.LEFT);
                both = new ButtonType(Localization.lang("Keep both", new Object[0]), ButtonBar.ButtonData.LEFT);
                this.threeWayMerge = new ThreeWayMergeView(one, two, this.preferencesService);
                break;
            }
            case 2: {
                first = new ButtonType(Localization.lang("Keep left", new Object[0]), ButtonBar.ButtonData.LEFT);
                second = new ButtonType(Localization.lang("Keep right", new Object[0]), ButtonBar.ButtonData.LEFT);
                both = new ButtonType(Localization.lang("Keep both", new Object[0]), ButtonBar.ButtonData.LEFT);
                removeExactVisible = true;
                this.threeWayMerge = new ThreeWayMergeView(one, two, this.preferencesService);
                break;
            }
            case 1: {
                first = new ButtonType(Localization.lang("Keep existing entry", new Object[0]), ButtonBar.ButtonData.LEFT);
                second = new ButtonType(Localization.lang("Keep from import", new Object[0]), ButtonBar.ButtonData.LEFT);
                both = new ButtonType(Localization.lang("Keep both", new Object[0]), ButtonBar.ButtonData.LEFT);
                this.threeWayMerge = new ThreeWayMergeView(one, two, Localization.lang("Existing entry", new Object[0]), Localization.lang("From import", new Object[0]), this.preferencesService);
                break;
            }
            default: {
                throw new IllegalStateException("Switch expression should be exhaustive");
            }
        }
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{first, second, both, merge, cancel});
        this.getDialogPane().setFocusTraversable(false);
        if (removeExactVisible) {
            this.getDialogPane().getButtonTypes().add((Object)removeExact);
            this.getDialogPane().getButtonTypes().stream().map(arg_0 -> ((DialogPane)this.getDialogPane()).lookupButton(arg_0)).forEach(btn -> ButtonBar.setButtonUniformSize((Node)btn, (boolean)false));
        }
        if ((state = this.stateManager.getDialogWindowState(((Object)((Object)this)).getClass().getSimpleName())) != null) {
            this.getDialogPane().setPrefSize(state.getWidth(), state.getHeight());
            this.setX(state.getX());
            this.setY(state.getY());
        }
        BorderPane borderPane = new BorderPane((Node)this.threeWayMerge);
        this.setResultConverter(button -> {
            this.stateManager.setDialogWindowState(((Object)((Object)this)).getClass().getSimpleName(), new DialogWindowState(this.getX(), this.getY(), this.getDialogPane().getHeight(), this.getDialogPane().getWidth()));
            this.threeWayMerge.saveConfiguration();
            if (button.equals(first)) {
                return DuplicateResolverResult.KEEP_LEFT;
            }
            if (button.equals(second)) {
                return DuplicateResolverResult.KEEP_RIGHT;
            }
            if (button.equals(both)) {
                return DuplicateResolverResult.KEEP_BOTH;
            }
            if (button.equals(merge)) {
                return DuplicateResolverResult.KEEP_MERGE;
            }
            if (button.equals(removeExact)) {
                return DuplicateResolverResult.AUTOREMOVE_EXACT;
            }
            if (button.equals(cancel)) {
                return DuplicateResolverResult.KEEP_LEFT;
            }
            return null;
        });
        HelpAction helpCommand = new HelpAction(HelpFile.FIND_DUPLICATES, this.dialogService, this.preferencesService.getFilePreferences());
        Button helpButton = this.actionFactory.createIconButton(StandardActions.HELP, (Command)helpCommand);
        borderPane.setRight((Node)helpButton);
        this.getDialogPane().setContent((Node)borderPane);
    }

    public BibEntry getMergedEntry() {
        return this.threeWayMerge.getMergedEntry();
    }

    public BibEntry getNewLeftEntry() {
        return this.threeWayMerge.getLeftEntry();
    }

    public BibEntry getNewRightEntry() {
        return this.threeWayMerge.getRightEntry();
    }

    public static enum DuplicateResolverType {
        DUPLICATE_SEARCH,
        IMPORT_CHECK,
        DUPLICATE_SEARCH_WITH_EXACT;

    }

    public static enum DuplicateResolverResult {
        KEEP_BOTH(Localization.lang("Keep both", new Object[0])),
        KEEP_LEFT(Localization.lang("Keep existing entry", new Object[0])),
        KEEP_RIGHT(Localization.lang("Keep from import", new Object[0])),
        AUTOREMOVE_EXACT(Localization.lang("Automatically remove exact duplicates", new Object[0])),
        KEEP_MERGE(Localization.lang("Keep merged", new Object[0])),
        BREAK(Localization.lang("Ask every time", new Object[0]));

        final String defaultTranslationForImport;

        private DuplicateResolverResult(String defaultTranslationForImport) {
            this.defaultTranslationForImport = defaultTranslationForImport;
        }

        public String getDefaultTranslationForImport() {
            return this.defaultTranslationForImport;
        }

        public static DuplicateResolverResult parse(String name) {
            try {
                return DuplicateResolverResult.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return BREAK;
            }
        }
    }
}

