/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor;

import java.util.List;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.strings.StringUtil;

public class MoveFieldValueAction
extends SimpleCommand {
    private final Field fromField;
    private final Field toField;
    private final List<BibEntry> entries;
    private final NamedCompound edits;
    private int affectedEntriesCount;
    private final boolean overwriteToFieldContent;

    public MoveFieldValueAction(Field fromField, Field toField, List<BibEntry> entries, NamedCompound edits, boolean overwriteToFieldContent) {
        this.fromField = fromField;
        this.toField = toField;
        this.entries = entries;
        this.edits = edits;
        this.overwriteToFieldContent = overwriteToFieldContent;
    }

    public MoveFieldValueAction(Field fromField, Field toField, List<BibEntry> entries, NamedCompound edits) {
        this(fromField, toField, entries, edits, true);
    }

    public void execute() {
        this.affectedEntriesCount = 0;
        for (BibEntry entry : this.entries) {
            String fromFieldValue = entry.getField(this.fromField).orElse("");
            String toFieldValue = entry.getField(this.toField).orElse("");
            if (!StringUtil.isNotBlank(fromFieldValue) || !this.overwriteToFieldContent && !toFieldValue.isEmpty()) continue;
            entry.setField(this.toField, fromFieldValue);
            entry.setField(this.fromField, "");
            this.edits.addEdit(new UndoableFieldChange(entry, this.fromField, fromFieldValue, null));
            this.edits.addEdit(new UndoableFieldChange(entry, this.toField, toFieldValue, fromFieldValue));
            ++this.affectedEntriesCount;
        }
        this.edits.end();
    }

    public int executeAndGetAffectedEntriesCount() {
        this.execute();
        return this.affectedEntriesCount;
    }
}

