/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.copyormovecontent;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabView;
import org.jabref.gui.edit.automaticfiededitor.AutomaticFieldEditorTab;
import org.jabref.gui.edit.automaticfiededitor.copyormovecontent.CopyOrMoveFieldContentTabViewModel;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class CopyOrMoveFieldContentTabView
extends AbstractAutomaticFieldEditorTabView
implements AutomaticFieldEditorTab {
    public Button copyContentButton;
    @FXML
    private Button moveContentButton;
    @FXML
    private Button swapContentButton;
    @FXML
    private ComboBox<Field> fromFieldComboBox;
    @FXML
    private ComboBox<Field> toFieldComboBox;
    @FXML
    private CheckBox overwriteFieldContentCheckBox;
    private CopyOrMoveFieldContentTabViewModel viewModel;
    private final List<BibEntry> selectedEntries;
    private final BibDatabase database;
    private final StateManager stateManager;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public CopyOrMoveFieldContentTabView(BibDatabase database, StateManager stateManager) {
        this.selectedEntries = new ArrayList<BibEntry>((Collection<BibEntry>)stateManager.getSelectedEntries());
        this.database = database;
        this.stateManager = stateManager;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    public void initialize() {
        this.viewModel = new CopyOrMoveFieldContentTabViewModel(this.selectedEntries, this.database, this.stateManager);
        this.initializeFromAndToComboBox();
        this.viewModel.overwriteFieldContentProperty().bindBidirectional((Property)this.overwriteFieldContentCheckBox.selectedProperty());
        this.moveContentButton.disableProperty().bind((ObservableValue)this.viewModel.canMoveProperty().not());
        this.swapContentButton.disableProperty().bind((ObservableValue)this.viewModel.canSwapProperty().not());
        this.copyContentButton.disableProperty().bind((ObservableValue)this.viewModel.toFieldValidationStatus().validProperty().not());
        this.overwriteFieldContentCheckBox.disableProperty().bind((ObservableValue)this.viewModel.toFieldValidationStatus().validProperty().not());
        Platform.runLater(() -> this.visualizer.initVisualization(this.viewModel.toFieldValidationStatus(), this.toFieldComboBox, true));
    }

    private void initializeFromAndToComboBox() {
        this.fromFieldComboBox.getItems().setAll(this.viewModel.getAllFields());
        this.toFieldComboBox.getItems().setAll(this.viewModel.getAllFields());
        this.fromFieldComboBox.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.toFieldComboBox.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.fromFieldComboBox.valueProperty().bindBidirectional(this.viewModel.fromFieldProperty());
        this.toFieldComboBox.valueProperty().bindBidirectional(this.viewModel.toFieldProperty());
        EasyBind.listen((ObservableValue)this.fromFieldComboBox.getEditor().textProperty(), observable -> this.fromFieldComboBox.commitValue());
        EasyBind.listen((ObservableValue)this.toFieldComboBox.getEditor().textProperty(), observable -> this.toFieldComboBox.commitValue());
    }

    @Override
    public String getTabName() {
        return Localization.lang("Copy or Move content", new Object[0]);
    }

    @FXML
    void copyContent() {
        this.viewModel.copyValue();
    }

    @FXML
    void moveContent() {
        this.viewModel.moveValue();
    }

    @FXML
    void swapContent() {
        this.viewModel.swapValues();
    }
}

