/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import org.jabref.gui.DialogService;
import org.jabref.gui.exporter.CreateModifyExporterDialogViewModel;
import org.jabref.gui.exporter.ExporterViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class CreateModifyExporterDialogView
extends BaseDialog<ExporterViewModel> {
    private final ExporterViewModel exporter;
    @FXML
    private TextField name;
    @FXML
    private TextField fileName;
    @FXML
    private TextField extension;
    @FXML
    private ButtonType saveExporter;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferences;
    private CreateModifyExporterDialogViewModel viewModel;

    public CreateModifyExporterDialogView(ExporterViewModel exporter) {
        this.setTitle(Localization.lang("Customize Export Formats", new Object[0]));
        this.exporter = exporter;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(button -> {
            if (button == this.saveExporter) {
                return this.viewModel.saveExporter();
            }
            return null;
        });
    }

    @FXML
    private void initialize() {
        this.viewModel = new CreateModifyExporterDialogViewModel(this.exporter, this.dialogService, this.preferences);
        this.name.textProperty().bindBidirectional((Property)this.viewModel.getName());
        this.fileName.textProperty().bindBidirectional((Property)this.viewModel.getLayoutFileName());
        this.extension.textProperty().bindBidirectional((Property)this.viewModel.getExtension());
    }

    @FXML
    private void browse(ActionEvent event) {
        this.viewModel.browse();
    }
}

