/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.scene.control.Button;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.fieldeditors.PopOverUtil;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.entry.field.Field;
import org.jabref.model.strings.StringUtil;

public class JournalEditorViewModel
extends AbstractEditorViewModel {
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final TaskExecutor taskExecutor;
    private final DialogService dialogService;

    public JournalEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, JournalAbbreviationRepository journalAbbreviationRepository, FieldCheckers fieldCheckers, TaskExecutor taskExecutor, DialogService dialogService, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.journalAbbreviationRepository = journalAbbreviationRepository;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
    }

    public void toggleAbbreviation() {
        if (StringUtil.isBlank((String)this.text.get())) {
            return;
        }
        String name = StringUtil.ignoreCurlyBracket((String)this.text.get());
        this.journalAbbreviationRepository.getNextAbbreviation(name).ifPresent(nextAbbreviation -> this.text.set(nextAbbreviation));
    }

    public void showJournalInfo(Button journalInfoButton) {
        PopOverUtil.showJournalInfo(journalInfoButton, this.entry, this.dialogService, this.taskExecutor);
    }
}

