/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.tobiasdiez.easybind.EasyBind;
import java.io.IOException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.fieldeditors.URLUtil;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;

public class UrlEditorViewModel
extends AbstractEditorViewModel {
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final BooleanProperty validUrlIsNotPresent = new SimpleBooleanProperty(true);

    public UrlEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, DialogService dialogService, PreferencesService preferencesService, FieldCheckers fieldCheckers, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.validUrlIsNotPresent.bind((ObservableValue)EasyBind.map((ObservableValue)this.text, input -> StringUtil.isBlank(input) || !URLUtil.isURL(input)));
    }

    public boolean isValidUrlIsNotPresent() {
        return this.validUrlIsNotPresent.get();
    }

    public BooleanProperty validUrlIsNotPresentProperty() {
        return this.validUrlIsNotPresent;
    }

    public void openExternalLink() {
        if (StringUtil.isBlank((String)this.text.get())) {
            return;
        }
        try {
            JabRefDesktop.openBrowser((String)this.text.get(), this.preferencesService.getFilePreferences());
        }
        catch (IOException ex) {
            this.dialogService.notify(Localization.lang("Unable to open link.", new Object[0]));
        }
    }
}

