/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import javax.swing.undo.CompoundEdit;
import org.jabref.gui.journals.AbbreviationType;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.AMSField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;

public class UndoableAbbreviator {
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final AbbreviationType abbreviationType;
    private final boolean useFJournalField;

    public UndoableAbbreviator(JournalAbbreviationRepository journalAbbreviationRepository, AbbreviationType abbreviationType, boolean useFJournalField) {
        this.journalAbbreviationRepository = journalAbbreviationRepository;
        this.abbreviationType = abbreviationType;
        this.useFJournalField = useFJournalField;
    }

    public boolean abbreviate(BibDatabase database, BibEntry entry, Field fieldName, CompoundEdit ce) {
        String text;
        if (!entry.hasField(fieldName)) {
            return false;
        }
        String origText = text = entry.getField(fieldName).get();
        if (database != null) {
            text = database.resolveForStrings(text);
        }
        if (!this.journalAbbreviationRepository.isKnownName(text)) {
            return false;
        }
        Abbreviation abbreviation = this.journalAbbreviationRepository.get(text).get();
        String newText = this.getAbbreviatedName(abbreviation);
        if (newText.equals(origText)) {
            return false;
        }
        if (this.useFJournalField && (StandardField.JOURNAL == fieldName || StandardField.JOURNALTITLE == fieldName)) {
            entry.setField(AMSField.FJOURNAL, abbreviation.getName());
            ce.addEdit(new UndoableFieldChange(entry, AMSField.FJOURNAL, null, abbreviation.getName()));
        }
        entry.setField(fieldName, newText);
        ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
        return true;
    }

    private String getAbbreviatedName(Abbreviation text) {
        switch (this.abbreviationType) {
            case DEFAULT: {
                return text.getAbbreviation();
            }
            case DOTLESS: {
                return text.getDotlessAbbreviation();
            }
            case SHORTEST_UNIQUE: {
                return text.getShortestUniqueAbbreviation();
            }
        }
        throw new IllegalStateException("Unexpected value: %s".formatted(new Object[]{this.abbreviationType}));
    }
}

