/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.airhacks.afterburner.injection.Injector;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import javax.swing.undo.UndoManager;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTableColumnModel {
    public static final Character COLUMNS_QUALIFIER_DELIMITER = Character.valueOf(':');
    private static final Logger LOGGER = LoggerFactory.getLogger(MainTableColumnModel.class);
    private final ObjectProperty<Type> typeProperty = new SimpleObjectProperty();
    private final StringProperty qualifierProperty = new SimpleStringProperty();
    private final DoubleProperty widthProperty = new SimpleDoubleProperty();
    private final ObjectProperty<TableColumn.SortType> sortTypeProperty = new SimpleObjectProperty();
    private final PreferencesService preferencesService;
    private final UndoManager undoManager;

    public MainTableColumnModel(Type type, String qualifier) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(qualifier);
        this.typeProperty.setValue((Object)type);
        this.qualifierProperty.setValue(qualifier);
        this.sortTypeProperty.setValue((Object)TableColumn.SortType.ASCENDING);
        this.preferencesService = (PreferencesService)Injector.instantiateModelOrService(PreferencesService.class);
        this.undoManager = (UndoManager)Injector.instantiateModelOrService(UndoManager.class);
        if (Type.ICON_COLUMNS.contains((Object)type)) {
            this.widthProperty.setValue((Number)28.0);
        } else {
            this.widthProperty.setValue((Number)100.0);
        }
    }

    public MainTableColumnModel(Type type) {
        this(type, "");
    }

    public MainTableColumnModel(Type type, String qualifier, double width) {
        this(type, qualifier);
        this.widthProperty.setValue((Number)width);
    }

    public Type getType() {
        return (Type)((Object)this.typeProperty.getValue());
    }

    public String getQualifier() {
        return this.qualifierProperty.getValue();
    }

    public String getName() {
        if (this.qualifierProperty.getValue().isBlank()) {
            return ((Type)((Object)this.typeProperty.getValue())).getName();
        }
        return ((Type)((Object)this.typeProperty.getValue())).getName() + COLUMNS_QUALIFIER_DELIMITER + this.qualifierProperty.getValue();
    }

    public String getDisplayName() {
        if (Type.ICON_COLUMNS.contains(this.typeProperty.getValue()) && this.qualifierProperty.getValue().isBlank() || this.typeProperty.getValue() == Type.INDEX) {
            return ((Type)((Object)this.typeProperty.getValue())).getDisplayName();
        }
        return FieldsUtil.getNameWithType(FieldFactory.parseField(this.qualifierProperty.getValue()), this.preferencesService, this.undoManager);
    }

    public StringProperty nameProperty() {
        return new ReadOnlyStringWrapper(this.getDisplayName());
    }

    public double getWidth() {
        return this.widthProperty.getValue();
    }

    public DoubleProperty widthProperty() {
        return this.widthProperty;
    }

    public TableColumn.SortType getSortType() {
        return (TableColumn.SortType)this.sortTypeProperty.getValue();
    }

    public ObjectProperty<TableColumn.SortType> sortTypeProperty() {
        return this.sortTypeProperty;
    }

    public List<SaveOrder.SortCriterion> getSortCriteria() {
        boolean descending = this.getSortType() == TableColumn.SortType.DESCENDING;
        return FieldFactory.parseOrFields(this.getQualifier()).getFields().stream().map(field -> new SaveOrder.SortCriterion((Field)field, descending)).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainTableColumnModel that = (MainTableColumnModel)o;
        if (this.typeProperty.getValue() != that.typeProperty.getValue()) {
            return false;
        }
        return Objects.equals(this.qualifierProperty.getValue(), that.qualifierProperty.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.typeProperty.getValue(), this.qualifierProperty.getValue());
    }

    public static MainTableColumnModel parse(String rawColumnName) {
        Objects.requireNonNull(rawColumnName);
        String[] splittedName = rawColumnName.split(COLUMNS_QUALIFIER_DELIMITER.toString());
        Type type = Type.fromString(splittedName[0]);
        String qualifier = "";
        if (type == Type.NORMALFIELD || type == Type.SPECIALFIELD || type == Type.EXTRAFILE) {
            qualifier = splittedName.length == 1 ? splittedName[0] : splittedName[1];
        }
        return new MainTableColumnModel(type, qualifier);
    }

    public static enum Type {
        INDEX("index", Localization.lang("Index", new Object[0])),
        EXTRAFILE("extrafile", Localization.lang("File type", new Object[0])),
        FILES("files", Localization.lang("Linked files", new Object[0])),
        GROUPS("groups", Localization.lang("Groups", new Object[0])),
        GROUP_ICONS("group_icons", Localization.lang("Group icons", new Object[0])),
        LINKED_IDENTIFIER("linked_id", Localization.lang("Linked identifiers", new Object[0])),
        NORMALFIELD("field"),
        SPECIALFIELD("special", Localization.lang("Special", new Object[0])),
        LIBRARY_NAME("library", Localization.lang("Library", new Object[0]));

        public static final EnumSet<Type> ICON_COLUMNS;
        private final String name;
        private final String displayName;

        private Type(String name) {
            this.name = name;
            this.displayName = name;
        }

        private Type(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static Type fromString(String text) {
            for (Type type : Type.values()) {
                if (!type.getName().equals(text)) continue;
                return type;
            }
            LOGGER.warn("Column type '{}' is unknown.", (Object)text);
            return NORMALFIELD;
        }

        static {
            ICON_COLUMNS = EnumSet.of(EXTRAFILE, FILES, GROUPS, GROUP_ICONS, LINKED_IDENTIFIER);
        }
    }
}

