/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.menus;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.swing.undo.UndoManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.menus.ChangeEntryTypeAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.types.BibtexEntryTypeDefinitions;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryTypeDefinitions;

public class ChangeEntryTypeMenu {
    private final List<BibEntry> entries;
    private final BibDatabaseContext bibDatabaseContext;
    private final UndoManager undoManager;
    private final ActionFactory factory;
    private final BibEntryTypesManager entryTypesManager;

    public ChangeEntryTypeMenu(List<BibEntry> entries, BibDatabaseContext bibDatabaseContext, UndoManager undoManager, BibEntryTypesManager entryTypesManager) {
        this.entries = entries;
        this.bibDatabaseContext = bibDatabaseContext;
        this.undoManager = undoManager;
        this.entryTypesManager = entryTypesManager;
        this.factory = new ActionFactory();
    }

    public ContextMenu asContextMenu() {
        ContextMenu menu = new ContextMenu();
        menu.getItems().setAll(this.getMenuItems(this.entries, this.bibDatabaseContext, this.undoManager));
        return menu;
    }

    public Menu asSubMenu() {
        Menu menu = new Menu(Localization.lang("Change entry type", new Object[0]));
        menu.getItems().setAll(this.getMenuItems(this.entries, this.bibDatabaseContext, this.undoManager));
        return menu;
    }

    private ObservableList<MenuItem> getMenuItems(List<BibEntry> entries, BibDatabaseContext bibDatabaseContext, UndoManager undoManager) {
        ObservableList items = FXCollections.observableArrayList();
        if (bibDatabaseContext.isBiblatexMode()) {
            items.addAll(this.fromEntryTypes(this.entryTypesManager.getAllTypes(BibDatabaseMode.BIBLATEX), entries, undoManager));
            this.createSubMenu(Localization.lang("Custom", new Object[0]), this.entryTypesManager.getAllCustomTypes(BibDatabaseMode.BIBLATEX), entries, undoManager).ifPresent(subMenu -> items.addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), subMenu}));
        } else {
            this.createSubMenu(BibDatabaseMode.BIBTEX.getFormattedName(), BibtexEntryTypeDefinitions.ALL, entries, undoManager).ifPresent(arg_0 -> items.add(arg_0));
            this.createSubMenu("IEEETran", IEEETranEntryTypeDefinitions.ALL, entries, undoManager).ifPresent(subMenu -> items.addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), subMenu}));
            this.createSubMenu(Localization.lang("Custom", new Object[0]), this.entryTypesManager.getAllCustomTypes(BibDatabaseMode.BIBTEX), entries, undoManager).ifPresent(subMenu -> items.addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), subMenu}));
        }
        return items;
    }

    private Optional<Menu> createSubMenu(String text, List<BibEntryType> entryTypes, List<BibEntry> entries, UndoManager undoManager) {
        Menu subMenu = null;
        if (!entryTypes.isEmpty()) {
            subMenu = this.factory.createMenu(() -> text);
            subMenu.getItems().addAll(this.fromEntryTypes(entryTypes, entries, undoManager));
        }
        return Optional.ofNullable(subMenu);
    }

    private List<MenuItem> fromEntryTypes(Collection<BibEntryType> types, List<BibEntry> entries, UndoManager undoManager) {
        return types.stream().map(BibEntryType::getType).map(type -> this.factory.createMenuItem(type::getDisplayName, (Command)new ChangeEntryTypeAction((EntryType)type, entries, undoManager))).toList();
    }
}

